/*
 * Decompiled with CFR 0.152.
 */
package org.retentionprediction;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.nio.DoubleBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import org.retentionprediction.AutoScaleEvent;
import org.retentionprediction.AutoScaleListener;

public class GraphControl
extends GLCanvas
implements GLEventListener,
MouseListener,
MouseMotionListener {
    static double NANOSECONDS = 1.0;
    static double MICROSECONDS = 1000.0;
    static double MILLISECONDS = 1000000.0;
    static double SECONDS = 1.0E9;
    static double MINUTES = 60.0 * SECONDS;
    static double HOURS = 60.0 * MINUTES;
    static double DAYS = 24.0 * HOURS;
    static double YEARS = 365.0 * DAYS;
    static double NANOUNITS = 1.0;
    static double MICROUNITS = 1000.0 * NANOUNITS;
    static double MILLIUNITS = 1000.0 * MICROUNITS;
    static double UNITS = 1000.0 * MILLIUNITS;
    static double KILOUNITS = 1000.0 * UNITS;
    static double MEGAUNITS = 1000.0 * KILOUNITS;
    DRect m_drectView = new DRect();
    DRect m_rectGraph = new DRect();
    double m_dXMultiplier;
    double m_dYMultiplier;
    double m_dSecondYMultiplier;
    double m_dInvXMultiplier;
    double m_dInvYMultiplier;
    double m_dSecondInvYMultiplier;
    int m_iMajorUnitTypeX;
    double m_dMajorUnitXTypeValue;
    double m_dNextMajorUnitXTypeValue;
    double m_dNextNextMajorUnitXTypeValue;
    String m_strXAxisLabel = "";
    String m_strXAxisLabelShort = "";
    boolean m_bXAxisRangeIndicatorsVisible = true;
    String m_strXAxisTitle = "Units";
    String m_strXAxisBaseUnit = "units";
    String m_strXAxisBaseUnitShort = "U";
    boolean m_bXAxisIsTime = true;
    int m_iMajorUnitTypeY;
    double m_dMajorUnitYTypeValue;
    double m_dNextMajorUnitYTypeValue;
    double m_dNextNextMajorUnitYTypeValue;
    String m_strYAxisLabel = "";
    String m_strYAxisLabelShort = "";
    boolean m_bYAxisRangeIndicatorsVisible = true;
    String m_strYAxisTitle = "Units";
    String m_strYAxisBaseUnit = "units";
    String m_strYAxisBaseUnitShort = "U";
    boolean m_bControlsEnabled = true;
    double m_dYAxisUpperLimit = 9.0 * MEGAUNITS;
    double m_dYAxisLowerLimit = -9.0 * MEGAUNITS;
    double m_dXAxisUpperLimit = 9.0 * MEGAUNITS;
    double m_dXAxisLowerLimit = -9.0 * MEGAUNITS;
    double m_dSecondYAxisUpperLimit = 9.0 * MEGAUNITS;
    double m_dSecondYAxisLowerLimit = -9.0 * MEGAUNITS;
    int m_iSecondMajorUnitTypeY;
    double m_dSecondMajorUnitYTypeValue;
    double m_dSecondNextMajorUnitYTypeValue;
    double m_dSecondNextNextMajorUnitYTypeValue;
    String m_strSecondYAxisLabel = "";
    String m_strSecondYAxisLabelShort = "";
    boolean m_bSecondYAxisVisible = false;
    String m_strSecondYAxisTitle = "Solvent B Fraction";
    String m_strSecondYAxisBaseUnit = "% v/v";
    String m_strSecondYAxisBaseUnitShort = "%";
    Vector<DataSeries> m_vectDataSeries = new Vector();
    Vector<LineMarker> m_vectLineMarkers = new Vector();
    static GLU glu = new GLU();
    static Font m_fontXAxisLabel = new Font("Dialog", 1, 12);
    static Font m_fontYAxisLabel = new Font("Dialog", 1, 12);
    static Font m_fontXAxisDivision = new Font("Dialog", 0, 12);
    static Font m_fontYAxisDivision = new Font("Dialog", 0, 12);
    static int JUSTIFY_LEFT = 0;
    static int JUSTIFY_CENTER = 1;
    static int JUSTIFY_RIGHT = 2;
    TextRenderer m_rendererXAxisLabel;
    TextRenderer m_rendererYAxisLabel;
    TextRenderer m_rendererXAxisDivision;
    TextRenderer m_rendererYAxisDivision;
    boolean m_bTranslating = false;
    boolean m_bZooming = false;
    boolean m_bResizing = false;
    boolean m_bZoomToolTracking = false;
    DRect m_ZoomSelRect = new DRect();
    boolean m_bLeftButtonDown = false;
    boolean m_bRightButtonDown = false;
    Point m_pointLastCursorPos = new Point();
    DRect m_drectLastViewPos = new DRect();
    int m_iMode = 0;
    Cursor m_curOpenHand;
    Cursor m_curClosedHand;
    Cursor m_curZoomIn;
    Cursor m_curZoomOut;
    boolean m_bAutoScaleX = true;
    boolean m_bAutoScaleY = true;
    private ArrayList<AutoScaleListener> _listeners = new ArrayList();
    Object lockObject = new Object();
    private static final long serialVersionUID = 1L;

    public GraphControl(GLCapabilities caps) {
        super(caps);
        this.setVisible(true);
        this.addGLEventListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setAutoSwapBufferMode(false);
        this.m_drectView.left = 0.0;
        this.m_drectView.top = 800.0 * MILLIUNITS;
        this.m_drectView.right = 15.0 * SECONDS;
        this.m_drectView.bottom = -800.0 * MILLIUNITS;
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glEnable(2848);
        gl.glHint(3154, 4354);
        this.m_rendererXAxisLabel = new TextRenderer(m_fontXAxisLabel, true, false);
        this.m_rendererYAxisLabel = new TextRenderer(m_fontYAxisLabel, true, false);
        this.m_rendererXAxisDivision = new TextRenderer(m_fontXAxisDivision, true, false);
        this.m_rendererYAxisDivision = new TextRenderer(m_fontYAxisDivision, true, false);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image imgOpenHand = toolkit.getImage(this.getClass().getResource("/org/retentionprediction/images/openhand.gif"));
        this.m_curOpenHand = toolkit.createCustomCursor(imgOpenHand, new Point(7, 7), "openhand");
        Image imgClosedHand = toolkit.getImage(this.getClass().getResource("/org/retentionprediction/images/closedhand.gif"));
        this.m_curClosedHand = toolkit.createCustomCursor(imgClosedHand, new Point(7, 7), "closedhand");
        Image imgZoomIn = toolkit.getImage(this.getClass().getResource("/org/retentionprediction/images/zoomin.gif"));
        this.m_curZoomIn = toolkit.createCustomCursor(imgZoomIn, new Point(0, 0), "zoomin");
        Image imgZoomOut = toolkit.getImage(this.getClass().getResource("/org/retentionprediction/images/zoomout.gif"));
        this.m_curZoomOut = toolkit.createCustomCursor(imgZoomOut, new Point(5, 5), "zoomout");
        if (this.m_bControlsEnabled) {
            this.setCursor(this.m_curOpenHand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable drawable) {
        Object object = this.lockObject;
        synchronized (object) {
            GL gl = drawable.getGL();
            gl.glViewport(0, 0, this.getWidth(), this.getHeight());
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            glu.gluOrtho2D(0.0, (double)this.getWidth(), 0.0, (double)this.getHeight());
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glTranslatef(0.375f, 0.375f, 0.0f);
            gl.glClear(16384);
            gl.glLineWidth(1.0f);
            this.DrawGraph();
            double[] upperXBoundPlane = new double[]{1.0, 0.0, 0.0, -this.m_rectGraph.left - 1.0};
            double[] lowerXBoundPlane = new double[]{-1.0, 0.0, 0.0, this.m_rectGraph.right};
            double[] upperYBoundPlane = new double[]{0.0, -1.0, 0.0, this.m_rectGraph.top};
            double[] lowerYBoundPlane = new double[]{0.0, 1.0, 0.0, -this.m_rectGraph.bottom - 1.0};
            gl.glClipPlane(12288, DoubleBuffer.wrap(upperXBoundPlane));
            gl.glEnable(12288);
            gl.glClipPlane(12289, DoubleBuffer.wrap(lowerXBoundPlane));
            gl.glEnable(12289);
            gl.glClipPlane(12290, DoubleBuffer.wrap(upperYBoundPlane));
            gl.glEnable(12290);
            gl.glClipPlane(12291, DoubleBuffer.wrap(lowerYBoundPlane));
            gl.glEnable(12291);
            this.DrawChannelLines();
            this.drawLineLabels();
            this.drawZoomBox();
            gl.glDisable(12288);
            gl.glDisable(12289);
            gl.glDisable(12290);
            gl.glDisable(12291);
            this.swapBuffers();
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    protected void processMouseEvent(MouseEvent e) {
        double MINWIDTH = 1.0;
        double MINHEIGHT = 20.0;
        if (e.getButton() == 1) {
            if (e.getID() == 501) {
                this.m_bLeftButtonDown = true;
                if (this.m_iMode == 0) {
                    if (!(this.m_bTranslating || this.m_bZooming || this.m_bResizing)) {
                        this.m_pointLastCursorPos = e.getPoint();
                        this.m_drectLastViewPos.top = this.m_drectView.top;
                        this.m_drectLastViewPos.bottom = this.m_drectView.bottom;
                        this.m_drectLastViewPos.left = this.m_drectView.left;
                        this.m_drectLastViewPos.right = this.m_drectView.right;
                        this.m_bTranslating = true;
                    }
                } else if (this.m_iMode == 1) {
                    if (!this.m_bZoomToolTracking) {
                        this.m_bZoomToolTracking = true;
                    }
                    this.m_ZoomSelRect.left = e.getPoint().x;
                    this.m_ZoomSelRect.right = e.getPoint().x;
                    int iWindowHeight = this.getHeight();
                    this.m_ZoomSelRect.top = iWindowHeight - e.getPoint().y;
                    this.m_ZoomSelRect.bottom = iWindowHeight - e.getPoint().y;
                }
            } else if (e.getID() == 502) {
                this.m_bLeftButtonDown = false;
                if (this.m_iMode == 0) {
                    this.m_bTranslating = false;
                } else if (this.m_iMode == 1) {
                    this.turnOffAutoScale();
                    this.m_bZoomToolTracking = false;
                    if (this.m_ZoomSelRect.right == this.m_ZoomSelRect.left || this.m_ZoomSelRect.top == this.m_ZoomSelRect.bottom) {
                        DRect dNewViewRect = new DRect();
                        double dWidth = this.m_drectView.right - this.m_drectView.left;
                        double dHeight = this.m_drectView.top - this.m_drectView.bottom;
                        double dMouseXPos = this.m_drectView.left + (this.m_ZoomSelRect.left - this.m_rectGraph.left) * this.m_dXMultiplier;
                        double dMouseYPos = this.m_drectView.bottom + (this.m_ZoomSelRect.bottom - this.m_rectGraph.bottom) * this.m_dYMultiplier;
                        if (dWidth * 0.5 > MINWIDTH) {
                            dNewViewRect.left = dMouseXPos - dWidth / 4.0;
                            dNewViewRect.right = dMouseXPos + dWidth / 4.0;
                        } else {
                            dNewViewRect.left = dMouseXPos - MINWIDTH / 2.0;
                            dNewViewRect.right = dMouseXPos + MINWIDTH / 2.0;
                            if (dNewViewRect.right > 104.0 * DAYS) {
                                dNewViewRect.right = 104.0 * DAYS;
                                dNewViewRect.left = dNewViewRect.right - 1.0;
                            }
                            if (dNewViewRect.left < -104.0 * DAYS) {
                                dNewViewRect.left = -104.0 * DAYS;
                                dNewViewRect.left += 1.0;
                            }
                        }
                        if (dHeight * 0.5 > MINHEIGHT) {
                            dNewViewRect.top = dMouseYPos + dHeight / 4.0;
                            dNewViewRect.bottom = dMouseYPos - dHeight / 4.0;
                        } else {
                            dNewViewRect.top = dMouseYPos + MINHEIGHT / 2.0;
                            dNewViewRect.bottom = dMouseYPos - MINHEIGHT / 2.0;
                            if (dNewViewRect.top > this.m_dYAxisUpperLimit) {
                                dNewViewRect.top = this.m_dYAxisUpperLimit;
                                dNewViewRect.bottom = dNewViewRect.top - 1.0;
                            }
                            if (dNewViewRect.bottom < this.m_dYAxisLowerLimit) {
                                dNewViewRect.bottom = this.m_dYAxisLowerLimit;
                                dNewViewRect.top = dNewViewRect.bottom + 1.0;
                            }
                        }
                        this.m_drectView.left = dNewViewRect.left;
                        this.m_drectView.right = dNewViewRect.right;
                        this.m_drectView.top = dNewViewRect.top;
                        this.m_drectView.bottom = dNewViewRect.bottom;
                        this.repaint();
                    } else {
                        DRect normalizedRect = new DRect();
                        DRect dNewViewRect = new DRect();
                        if (this.m_ZoomSelRect.top > this.m_ZoomSelRect.bottom) {
                            normalizedRect.top = this.m_ZoomSelRect.top;
                            normalizedRect.bottom = this.m_ZoomSelRect.bottom;
                        } else {
                            normalizedRect.top = this.m_ZoomSelRect.bottom;
                            normalizedRect.bottom = this.m_ZoomSelRect.top;
                        }
                        if (this.m_ZoomSelRect.right > this.m_ZoomSelRect.left) {
                            normalizedRect.right = this.m_ZoomSelRect.right;
                            normalizedRect.left = this.m_ZoomSelRect.left;
                        } else {
                            normalizedRect.right = this.m_ZoomSelRect.left;
                            normalizedRect.left = this.m_ZoomSelRect.right;
                        }
                        dNewViewRect.left = this.m_drectView.left + (normalizedRect.left - this.m_rectGraph.left) * this.m_dXMultiplier;
                        dNewViewRect.right = this.m_drectView.left + (normalizedRect.right - this.m_rectGraph.left) * this.m_dXMultiplier;
                        dNewViewRect.top = this.m_drectView.bottom + (normalizedRect.top - this.m_rectGraph.bottom) * this.m_dYMultiplier;
                        dNewViewRect.bottom = this.m_drectView.bottom + (normalizedRect.bottom - this.m_rectGraph.bottom) * this.m_dYMultiplier;
                        if (dNewViewRect.getWidth() < MINWIDTH) {
                            double centerx = dNewViewRect.left + dNewViewRect.getWidth() / 2.0;
                            dNewViewRect.left = centerx - MINWIDTH * 0.5;
                            dNewViewRect.right = dNewViewRect.left + MINWIDTH;
                        }
                        if (dNewViewRect.getHeight() < MINHEIGHT) {
                            double centery = dNewViewRect.bottom + dNewViewRect.getHeight() / 2.0;
                            dNewViewRect.bottom = centery - MINHEIGHT * 0.5;
                            dNewViewRect.top = dNewViewRect.bottom + MINHEIGHT;
                        }
                        double dWidth = dNewViewRect.getWidth();
                        double dHeight = dNewViewRect.getHeight();
                        if (dNewViewRect.right > 104.0 * DAYS) {
                            dNewViewRect.right = 104.0 * DAYS;
                            dNewViewRect.left = dNewViewRect.right - dWidth;
                        }
                        if (dNewViewRect.left < -104.0 * DAYS) {
                            dNewViewRect.left = -104.0 * DAYS;
                            dNewViewRect.left += dWidth;
                        }
                        if (dNewViewRect.top > this.m_dYAxisUpperLimit) {
                            dNewViewRect.top = this.m_dYAxisUpperLimit;
                            dNewViewRect.bottom = dNewViewRect.top - dHeight;
                        }
                        if (dNewViewRect.bottom < this.m_dYAxisLowerLimit) {
                            dNewViewRect.bottom = this.m_dYAxisLowerLimit;
                            dNewViewRect.top = dNewViewRect.bottom + dHeight;
                        }
                        this.m_drectView.left = dNewViewRect.left;
                        this.m_drectView.right = dNewViewRect.right;
                        this.m_drectView.top = dNewViewRect.top;
                        this.m_drectView.bottom = dNewViewRect.bottom;
                        this.repaint();
                    }
                } else if (this.m_iMode == 2) {
                    this.turnOffAutoScale();
                    DRect dNewViewRect = new DRect();
                    double dWidth = this.m_drectView.right - this.m_drectView.left;
                    double dHeight = this.m_drectView.top - this.m_drectView.bottom;
                    int iWindowHeight = this.getHeight();
                    double dMouseXPos = this.m_drectView.left + ((double)e.getPoint().x - this.m_rectGraph.left) * this.m_dXMultiplier;
                    double dMouseYPos = this.m_drectView.bottom + ((double)(iWindowHeight - e.getPoint().y) - this.m_rectGraph.bottom) * this.m_dYMultiplier;
                    dNewViewRect.left = dMouseXPos - dWidth;
                    dNewViewRect.right = dMouseXPos + dWidth;
                    dNewViewRect.top = dMouseYPos + dHeight;
                    dNewViewRect.bottom = dMouseYPos - dHeight;
                    if (dNewViewRect.left < -104.0 * DAYS) {
                        dNewViewRect.left = -104.0 * DAYS;
                    }
                    if (dNewViewRect.right > 104.0 * DAYS) {
                        dNewViewRect.right = 104.0 * DAYS;
                    }
                    if (dNewViewRect.bottom < this.m_dYAxisLowerLimit) {
                        dNewViewRect.bottom = this.m_dYAxisLowerLimit;
                    }
                    if (dNewViewRect.top > this.m_dYAxisUpperLimit) {
                        dNewViewRect.top = this.m_dYAxisUpperLimit;
                    }
                    this.m_drectView.left = dNewViewRect.left;
                    this.m_drectView.right = dNewViewRect.right;
                    this.m_drectView.top = dNewViewRect.top;
                    this.m_drectView.bottom = dNewViewRect.bottom;
                    this.repaint();
                }
            }
        } else if (e.getButton() == 3) {
            if (e.getID() == 501) {
                this.m_bRightButtonDown = true;
                if (!(this.m_iMode != 0 || this.m_bZooming || this.m_bTranslating || this.m_bResizing)) {
                    this.m_pointLastCursorPos = e.getPoint();
                    this.m_drectLastViewPos.top = this.m_drectView.top;
                    this.m_drectLastViewPos.bottom = this.m_drectView.bottom;
                    this.m_drectLastViewPos.left = this.m_drectView.left;
                    this.m_drectLastViewPos.right = this.m_drectView.right;
                    if (e.isShiftDown()) {
                        this.m_bResizing = true;
                    } else {
                        this.m_bZooming = true;
                    }
                }
            } else if (e.getID() == 502) {
                this.m_bRightButtonDown = false;
                this.m_bZooming = false;
                this.m_bResizing = false;
            }
        }
        super.processMouseEvent(e);
    }

    protected void turnOnAutoScaleX() {
        if (!this.m_bAutoScaleX) {
            this.m_bAutoScaleX = true;
            this.fireAutoScaleChangedEvent();
        }
    }

    protected void turnOnAutoScaleY() {
        if (!this.m_bAutoScaleY) {
            this.m_bAutoScaleY = true;
            this.fireAutoScaleChangedEvent();
        }
    }

    protected void turnOffAutoScale() {
        if (this.m_bAutoScaleX || this.m_bAutoScaleY) {
            this.m_bAutoScaleX = false;
            this.m_bAutoScaleY = false;
            this.fireAutoScaleChangedEvent();
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        Point pointCursor = e.getPoint();
        if (this.m_bControlsEnabled) {
            if (this.m_iMode == 0) {
                if (this.m_bTranslating) {
                    this.turnOffAutoScale();
                    if (this.m_drectLastViewPos.top + (double)(pointCursor.y - this.m_pointLastCursorPos.y) * this.m_dYMultiplier <= this.m_dYAxisUpperLimit && this.m_drectLastViewPos.top + (double)(pointCursor.y - this.m_pointLastCursorPos.y) * this.m_dYMultiplier - this.m_drectLastViewPos.getHeight() >= this.m_dYAxisLowerLimit) {
                        this.m_drectView.top = this.m_drectLastViewPos.top + this.m_dYMultiplier * (double)(pointCursor.y - this.m_pointLastCursorPos.y);
                        this.m_drectView.bottom = this.m_drectView.top - this.m_drectLastViewPos.getHeight();
                    } else if (this.m_drectLastViewPos.top + (double)(pointCursor.y - this.m_pointLastCursorPos.y) * this.m_dYMultiplier > this.m_dYAxisUpperLimit) {
                        this.m_drectView.top = this.m_dYAxisUpperLimit;
                        this.m_drectView.bottom = this.m_drectView.top - this.m_drectLastViewPos.getHeight();
                    } else if (this.m_drectLastViewPos.top + (double)(pointCursor.y - this.m_pointLastCursorPos.y) * this.m_dYMultiplier - this.m_drectLastViewPos.getHeight() < this.m_dYAxisLowerLimit) {
                        this.m_drectView.bottom = this.m_dYAxisLowerLimit;
                        this.m_drectView.top = this.m_drectView.bottom + this.m_drectLastViewPos.getHeight();
                    }
                    if (this.m_drectLastViewPos.left - (double)(pointCursor.x - this.m_pointLastCursorPos.x) * this.m_dXMultiplier >= -104.0 * DAYS && this.m_drectLastViewPos.left - (double)(pointCursor.x - this.m_pointLastCursorPos.x) * this.m_dXMultiplier + this.m_drectLastViewPos.getWidth() <= 104.0 * DAYS) {
                        this.m_drectView.left = this.m_drectLastViewPos.left - this.m_dXMultiplier * (double)(pointCursor.x - this.m_pointLastCursorPos.x);
                        this.m_drectView.right = this.m_drectView.left + this.m_drectLastViewPos.getWidth();
                    } else if (this.m_drectLastViewPos.left - (double)(pointCursor.x - this.m_pointLastCursorPos.x) * this.m_dXMultiplier < -104.0 * DAYS) {
                        this.m_drectView.left = -104.0 * DAYS;
                        this.m_drectView.right = this.m_drectView.left + this.m_drectLastViewPos.getWidth();
                    } else if (this.m_drectLastViewPos.left - (double)(pointCursor.x - this.m_pointLastCursorPos.x) * this.m_dXMultiplier + this.m_drectLastViewPos.getWidth() > 104.0 * DAYS) {
                        this.m_drectView.right = 104.0 * DAYS;
                        this.m_drectView.left = this.m_drectView.right - this.m_drectLastViewPos.getWidth();
                    }
                    this.repaint();
                } else if (this.m_bZooming) {
                    double dfactor = Math.pow(1.05, this.m_pointLastCursorPos.y - pointCursor.y);
                    double MINWIDTH = 1.0;
                    double MINHEIGHT = 20.0;
                    this.turnOffAutoScale();
                    if (this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactor * 0.5 - (this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactor * 0.5) > MINWIDTH) {
                        this.m_drectView.left = this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactor * 0.5 < -104.0 * DAYS ? -104.0 * DAYS : this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactor * 0.5;
                        this.m_drectView.right = this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactor * 0.5 > 104.0 * DAYS ? 104.0 * DAYS : this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactor * 0.5;
                    } else {
                        double centerh = this.m_drectView.left + (this.m_drectView.right - this.m_drectView.left) * 0.5;
                        this.m_drectView.left = centerh - MINWIDTH * 0.5;
                        this.m_drectView.right = centerh + MINWIDTH * 0.5;
                    }
                    if (this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactor * 0.5 - (this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactor * 0.5) > MINHEIGHT) {
                        this.m_drectView.top = this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactor * 0.5 > this.m_dYAxisUpperLimit ? this.m_dYAxisUpperLimit : this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactor * 0.5;
                        this.m_drectView.bottom = this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactor * 0.5 < this.m_dYAxisLowerLimit ? this.m_dYAxisLowerLimit : this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactor * 0.5;
                    } else {
                        double centerv = this.m_drectView.bottom + (this.m_drectView.top - this.m_drectView.bottom) * 0.5;
                        this.m_drectView.top = centerv + MINHEIGHT * 0.5;
                        this.m_drectView.bottom = centerv - MINHEIGHT * 0.5;
                    }
                    this.repaint();
                } else if (this.m_bResizing) {
                    double dfactory = Math.pow(1.05, this.m_pointLastCursorPos.y - pointCursor.y);
                    double dfactorx = Math.pow(1.05, this.m_pointLastCursorPos.x - pointCursor.x);
                    double MINWIDTH = 1.0;
                    double MINHEIGHT = 20.0;
                    this.turnOffAutoScale();
                    if (this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactorx * 0.5 - (this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactorx * 0.5) > MINWIDTH) {
                        this.m_drectView.left = this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactorx * 0.5 < -104.0 * DAYS ? -104.0 * DAYS : this.m_drectLastViewPos.left + this.m_drectLastViewPos.getWidth() * 0.5 - this.m_drectLastViewPos.getWidth() * dfactorx * 0.5;
                        this.m_drectView.right = this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactorx * 0.5 > 104.0 * DAYS ? 104.0 * DAYS : this.m_drectLastViewPos.right - this.m_drectLastViewPos.getWidth() * 0.5 + this.m_drectLastViewPos.getWidth() * dfactorx * 0.5;
                    } else {
                        double centerh = this.m_drectView.left + (this.m_drectView.right - this.m_drectView.left) * 0.5;
                        this.m_drectView.left = centerh - MINWIDTH * 0.5;
                        this.m_drectView.right = centerh + MINWIDTH * 0.5;
                    }
                    if (this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactory * 0.5 - (this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactory * 0.5) > MINHEIGHT) {
                        this.m_drectView.top = this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactory * 0.5 > this.m_dYAxisUpperLimit ? this.m_dYAxisUpperLimit : this.m_drectLastViewPos.top - this.m_drectLastViewPos.getHeight() * 0.5 + this.m_drectLastViewPos.getHeight() * dfactory * 0.5;
                        this.m_drectView.bottom = this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactory * 0.5 < this.m_dYAxisLowerLimit ? this.m_dYAxisLowerLimit : this.m_drectLastViewPos.bottom + this.m_drectLastViewPos.getHeight() * 0.5 - this.m_drectLastViewPos.getHeight() * dfactory * 0.5;
                    } else {
                        double centerv = this.m_drectView.bottom + (this.m_drectView.top - this.m_drectView.bottom) * 0.5;
                        this.m_drectView.top = centerv + MINHEIGHT * 0.5;
                        this.m_drectView.bottom = centerv - MINHEIGHT * 0.5;
                    }
                    this.repaint();
                }
            } else if (this.m_iMode == 1 && this.m_bZoomToolTracking) {
                this.m_ZoomSelRect.right = pointCursor.x;
                int iWindowHeight = this.getHeight();
                this.m_ZoomSelRect.bottom = iWindowHeight - pointCursor.y;
                this.repaint();
            }
        }
        this.m_pointLastCursorPos.x = e.getPoint().x;
        this.m_pointLastCursorPos.y = e.getPoint().y;
        this.m_drectLastViewPos.top = this.m_drectView.top;
        this.m_drectLastViewPos.bottom = this.m_drectView.bottom;
        this.m_drectLastViewPos.left = this.m_drectView.left;
        this.m_drectLastViewPos.right = this.m_drectView.right;
        super.processMouseMotionEvent(e);
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    /*
     * Unable to fully structure code
     */
    public void DrawGraph() {
        block141: {
            block140: {
                gl = this.getGL();
                MINOR_LINE_LENGTH = 2;
                MAJOR_LINE_LENGTH = 6;
                strNextXAxisLabel = "";
                strNextYAxisLabel = "";
                strSecondNextYAxisLabel = "";
                rectWindow = new DRect();
                rectWindow.bottom = 0.0;
                rectWindow.top = this.getHeight();
                rectWindow.left = 0.0;
                rectWindow.right = this.getWidth();
                graphics = this.getGraphics();
                metricsXAxisLabel = graphics.getFontMetrics(GraphControl.m_fontYAxisLabel);
                metricsYAxisLabel = graphics.getFontMetrics(GraphControl.m_fontXAxisLabel);
                metricsXAxisDivision = graphics.getFontMetrics(GraphControl.m_fontXAxisDivision);
                metricsYAxisDivision = graphics.getFontMetrics(GraphControl.m_fontYAxisDivision);
                GREAT_LINE_LENGTH = MAJOR_LINE_LENGTH + metricsXAxisDivision.getAscent();
                decformat = new DecimalFormat("#.#");
                this.m_rectGraph.left = this.m_bYAxisRangeIndicatorsVisible != false ? rectWindow.left + 2.0 + (double)metricsYAxisLabel.getHeight() + (double)(2 * metricsYAxisDivision.getHeight()) + (double)GREAT_LINE_LENGTH : rectWindow.left + 2.0 + (double)metricsYAxisLabel.getHeight() + (double)(1 * metricsYAxisDivision.getHeight()) + (double)GREAT_LINE_LENGTH;
                this.m_rectGraph.bottom = this.m_bXAxisRangeIndicatorsVisible != false ? rectWindow.bottom + (double)(3 * metricsXAxisDivision.getHeight()) + 2.0 + (double)GREAT_LINE_LENGTH : rectWindow.bottom + (double)(2 * metricsXAxisDivision.getHeight()) + 2.0 + (double)GREAT_LINE_LENGTH;
                this.m_rectGraph.right = this.m_bSecondYAxisVisible != false ? rectWindow.right - 2.0 - (double)metricsYAxisLabel.getHeight() - (double)(1 * metricsYAxisDivision.getHeight()) - (double)GREAT_LINE_LENGTH : rectWindow.right - 5.0;
                this.m_rectGraph.top = rectWindow.top - 5.0;
                this.m_dXMultiplier = (this.m_drectView.right - this.m_drectView.left) / (this.m_rectGraph.right - this.m_rectGraph.left);
                this.m_dYMultiplier = (this.m_drectView.top - this.m_drectView.bottom) / (this.m_rectGraph.top - this.m_rectGraph.bottom);
                this.m_dSecondYMultiplier = (this.m_dSecondYAxisUpperLimit - this.m_dSecondYAxisLowerLimit) / (this.m_rectGraph.top - this.m_rectGraph.bottom);
                this.m_dInvXMultiplier = 1.0 / this.m_dXMultiplier;
                this.m_dInvYMultiplier = 1.0 / this.m_dYMultiplier;
                this.m_dSecondInvYMultiplier = 1.0 / this.m_dSecondYMultiplier;
                dFrameRefX = this.m_dXMultiplier * 20.0;
                dDifferenceX = this.m_drectView.right - this.m_drectView.left;
                dMajorUnitX = 0.0;
                if (this.m_bXAxisIsTime) {
                    if (dFrameRefX <= 50.0 * GraphControl.NANOSECONDS) {
                        dMajorUnitX = 1.0 >= dFrameRefX ? 1.0 : (2.0 >= dFrameRefX ? 2.0 : (5.0 >= dFrameRefX ? 5.0 : (10.0 >= dFrameRefX ? 10.0 : (20.0 >= dFrameRefX ? 20.0 : 50.0))));
                        this.m_iMajorUnitTypeX = 1;
                        this.m_dMajorUnitXTypeValue = 1.0;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.MICROSECONDS;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.MILLISECONDS;
                        this.m_strXAxisLabel = "nanosec";
                        this.m_strXAxisLabelShort = "ns";
                        strNextXAxisLabel = "\u03bcs";
                    } else if (dFrameRefX <= 50.0 * GraphControl.MICROSECONDS) {
                        dMajorUnitX = 0.1 * GraphControl.MICROSECONDS >= dFrameRefX ? 0.1 * GraphControl.MICROSECONDS : (0.2 * GraphControl.MICROSECONDS >= dFrameRefX ? 0.2 * GraphControl.MICROSECONDS : (0.5 * GraphControl.MICROSECONDS >= dFrameRefX ? 0.5 * GraphControl.MICROSECONDS : (1.0 * GraphControl.MICROSECONDS >= dFrameRefX ? 1.0 * GraphControl.MICROSECONDS : (2.0 * GraphControl.MICROSECONDS >= dFrameRefX ? 2.0 * GraphControl.MICROSECONDS : (5.0 * GraphControl.MICROSECONDS >= dFrameRefX ? 5.0 * GraphControl.MICROSECONDS : (10.0 * GraphControl.MICROSECONDS >= dFrameRefX ? 10.0 * GraphControl.MICROSECONDS : (20.0 * GraphControl.MICROSECONDS >= dFrameRefX ? 20.0 * GraphControl.MICROSECONDS : 50.0 * GraphControl.MICROSECONDS)))))));
                        this.m_iMajorUnitTypeX = 2;
                        this.m_dMajorUnitXTypeValue = GraphControl.MICROSECONDS;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.MILLISECONDS;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.SECONDS;
                        this.m_strXAxisLabel = "microsec";
                        this.m_strXAxisLabelShort = "\u03bcs";
                        strNextXAxisLabel = "ms";
                    } else if (dFrameRefX <= 50.0 * GraphControl.MILLISECONDS) {
                        dMajorUnitX = 0.1 * GraphControl.MILLISECONDS >= dFrameRefX ? 0.1 * GraphControl.MILLISECONDS : (0.2 * GraphControl.MILLISECONDS >= dFrameRefX ? 0.2 * GraphControl.MILLISECONDS : (0.5 * GraphControl.MILLISECONDS >= dFrameRefX ? 0.5 * GraphControl.MILLISECONDS : (1.0 * GraphControl.MILLISECONDS >= dFrameRefX ? 1.0 * GraphControl.MILLISECONDS : (2.0 * GraphControl.MILLISECONDS >= dFrameRefX ? 2.0 * GraphControl.MILLISECONDS : (5.0 * GraphControl.MILLISECONDS >= dFrameRefX ? 5.0 * GraphControl.MILLISECONDS : (10.0 * GraphControl.MILLISECONDS >= dFrameRefX ? 10.0 * GraphControl.MILLISECONDS : (20.0 * GraphControl.MILLISECONDS >= dFrameRefX ? 20.0 * GraphControl.MILLISECONDS : 50.0 * GraphControl.MILLISECONDS)))))));
                        this.m_iMajorUnitTypeX = 3;
                        this.m_dMajorUnitXTypeValue = GraphControl.MILLISECONDS;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.SECONDS;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.MINUTES;
                        this.m_strXAxisLabel = "millisec";
                        this.m_strXAxisLabelShort = "ms";
                        strNextXAxisLabel = "s";
                    } else if (dFrameRefX <= 5.0 * GraphControl.SECONDS) {
                        dMajorUnitX = 0.1 * GraphControl.SECONDS >= dFrameRefX ? 0.1 * GraphControl.SECONDS : (0.2 * GraphControl.SECONDS >= dFrameRefX ? 0.2 * GraphControl.SECONDS : (0.5 * GraphControl.SECONDS >= dFrameRefX ? 0.5 * GraphControl.SECONDS : (1.0 * GraphControl.SECONDS >= dFrameRefX ? 1.0 * GraphControl.SECONDS : (2.0 * GraphControl.SECONDS >= dFrameRefX ? 2.0 * GraphControl.SECONDS : 5.0 * GraphControl.SECONDS))));
                        this.m_iMajorUnitTypeX = 4;
                        this.m_dMajorUnitXTypeValue = GraphControl.SECONDS;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.MINUTES;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.HOURS;
                        this.m_strXAxisLabel = "sec";
                        this.m_strXAxisLabelShort = "s";
                        strNextXAxisLabel = "min";
                    } else if (dFrameRefX <= 5.0 * GraphControl.MINUTES) {
                        dMajorUnitX = 0.2 * GraphControl.MINUTES >= dFrameRefX ? 0.2 * GraphControl.MINUTES : (0.5 * GraphControl.MINUTES >= dFrameRefX ? 0.5 * GraphControl.MINUTES : (1.0 * GraphControl.MINUTES >= dFrameRefX ? 1.0 * GraphControl.MINUTES : (2.0 * GraphControl.MINUTES >= dFrameRefX ? 2.0 * GraphControl.MINUTES : 5.0 * GraphControl.MINUTES)));
                        this.m_iMajorUnitTypeX = 5;
                        this.m_dMajorUnitXTypeValue = GraphControl.MINUTES;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.HOURS;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.DAYS;
                        this.m_strXAxisLabel = "min";
                        this.m_strXAxisLabelShort = "min";
                        strNextXAxisLabel = "hr";
                    } else if (dFrameRefX <= 2.0 * GraphControl.HOURS) {
                        dMajorUnitX = 0.2 * GraphControl.HOURS >= dFrameRefX ? 0.2 * GraphControl.HOURS : (0.5 * GraphControl.HOURS >= dFrameRefX ? 0.5 * GraphControl.HOURS : (1.0 * GraphControl.HOURS >= dFrameRefX ? 1.0 * GraphControl.HOURS : 2.0 * GraphControl.HOURS));
                        this.m_iMajorUnitTypeX = 6;
                        this.m_dMajorUnitXTypeValue = GraphControl.HOURS;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.DAYS;
                        this.m_dNextNextMajorUnitXTypeValue = GraphControl.YEARS;
                        this.m_strXAxisLabel = "hour";
                        this.m_strXAxisLabelShort = "hr";
                        strNextXAxisLabel = "day";
                    } else if (dFrameRefX <= 73.0 * GraphControl.DAYS) {
                        dMajorUnitX = 0.2 * GraphControl.DAYS >= dFrameRefX ? 0.2 * GraphControl.DAYS : (0.5 * GraphControl.DAYS >= dFrameRefX ? 0.5 * GraphControl.DAYS : (1.0 * GraphControl.DAYS >= dFrameRefX ? 1.0 * GraphControl.DAYS : (5.0 * GraphControl.DAYS >= dFrameRefX ? 5.0 * GraphControl.DAYS : 73.0 * GraphControl.DAYS)));
                        this.m_iMajorUnitTypeX = 7;
                        this.m_dMajorUnitXTypeValue = GraphControl.DAYS;
                        this.m_dNextMajorUnitXTypeValue = GraphControl.YEARS;
                        this.m_strXAxisLabel = "day";
                        this.m_strXAxisLabelShort = "day";
                        strNextXAxisLabel = "yr";
                    } else {
                        dMajorUnitX = 0.5 * GraphControl.YEARS >= dFrameRefX ? 0.5 * GraphControl.YEARS : (1.0 * GraphControl.YEARS >= dFrameRefX ? 1.0 * GraphControl.YEARS : (2.0 * GraphControl.YEARS >= dFrameRefX ? 2.0 * GraphControl.YEARS : (5.0 * GraphControl.YEARS >= dFrameRefX ? 5.0 * GraphControl.YEARS : (10.0 * GraphControl.YEARS >= dFrameRefX ? 10.0 * GraphControl.YEARS : (20.0 * GraphControl.YEARS >= dFrameRefX ? 20.0 * GraphControl.YEARS : 50.0 * GraphControl.YEARS)))));
                        this.m_iMajorUnitTypeX = 8;
                        this.m_dMajorUnitXTypeValue = GraphControl.YEARS;
                        this.m_strXAxisLabel = "year";
                        this.m_strXAxisLabelShort = "yr";
                    }
                } else if (dFrameRefX <= 50.0 * GraphControl.NANOUNITS) {
                    dMajorUnitX = 1.0 >= dFrameRefX ? 1.0 : (2.0 >= dFrameRefX ? 2.0 : (5.0 >= dFrameRefX ? 5.0 : (10.0 >= dFrameRefX ? 10.0 : (20.0 >= dFrameRefX ? 20.0 : 50.0))));
                    this.m_iMajorUnitTypeX = 1;
                    this.m_dMajorUnitXTypeValue = GraphControl.NANOUNITS;
                    this.m_dNextMajorUnitXTypeValue = GraphControl.MICROUNITS;
                    this.m_dNextNextMajorUnitXTypeValue = GraphControl.MILLIUNITS;
                    this.m_strXAxisLabel = "nano" + this.m_strXAxisBaseUnit;
                    this.m_strXAxisLabelShort = "n" + this.m_strXAxisBaseUnitShort;
                    strNextXAxisLabel = "\u03bc" + this.m_strXAxisBaseUnitShort;
                } else if (dFrameRefX <= 50.0 * GraphControl.MICROUNITS) {
                    dMajorUnitX = 0.1 * GraphControl.MICROUNITS >= dFrameRefX ? 0.1 * GraphControl.MICROUNITS : (0.2 * GraphControl.MICROUNITS >= dFrameRefX ? 0.2 * GraphControl.MICROUNITS : (0.5 * GraphControl.MICROUNITS >= dFrameRefX ? 0.5 * GraphControl.MICROUNITS : (1.0 * GraphControl.MICROUNITS >= dFrameRefX ? 1.0 * GraphControl.MICROUNITS : (2.0 * GraphControl.MICROUNITS >= dFrameRefX ? 2.0 * GraphControl.MICROUNITS : (5.0 * GraphControl.MICROUNITS >= dFrameRefX ? 5.0 * GraphControl.MICROUNITS : (10.0 * GraphControl.MICROUNITS >= dFrameRefX ? 10.0 * GraphControl.MICROUNITS : (20.0 * GraphControl.MICROUNITS >= dFrameRefX ? 20.0 * GraphControl.MICROUNITS : 50.0 * GraphControl.MICROUNITS)))))));
                    this.m_iMajorUnitTypeX = 2;
                    this.m_dMajorUnitXTypeValue = GraphControl.MICROUNITS;
                    this.m_dNextMajorUnitXTypeValue = GraphControl.MILLIUNITS;
                    this.m_dNextNextMajorUnitXTypeValue = GraphControl.UNITS;
                    this.m_strXAxisLabel = "micro" + this.m_strXAxisBaseUnit;
                    this.m_strXAxisLabelShort = "\u03bc" + this.m_strXAxisBaseUnitShort;
                    strNextXAxisLabel = "m" + this.m_strXAxisBaseUnitShort;
                } else if (dFrameRefX <= 50.0 * GraphControl.MILLIUNITS) {
                    dMajorUnitX = 0.1 * GraphControl.MILLIUNITS >= dFrameRefX ? 0.1 * GraphControl.MILLIUNITS : (0.2 * GraphControl.MILLIUNITS >= dFrameRefX ? 0.2 * GraphControl.MILLIUNITS : (0.5 * GraphControl.MILLIUNITS >= dFrameRefX ? 0.5 * GraphControl.MILLIUNITS : (1.0 * GraphControl.MILLIUNITS >= dFrameRefX ? 1.0 * GraphControl.MILLIUNITS : (2.0 * GraphControl.MILLIUNITS >= dFrameRefX ? 2.0 * GraphControl.MILLIUNITS : (5.0 * GraphControl.MILLIUNITS >= dFrameRefX ? 5.0 * GraphControl.MILLIUNITS : (10.0 * GraphControl.MILLIUNITS >= dFrameRefX ? 10.0 * GraphControl.MILLIUNITS : (20.0 * GraphControl.MILLIUNITS >= dFrameRefX ? 20.0 * GraphControl.MILLIUNITS : 50.0 * GraphControl.MILLIUNITS)))))));
                    this.m_iMajorUnitTypeX = 3;
                    this.m_dMajorUnitXTypeValue = GraphControl.MILLIUNITS;
                    this.m_dNextMajorUnitXTypeValue = GraphControl.UNITS;
                    this.m_dNextNextMajorUnitXTypeValue = GraphControl.KILOUNITS;
                    this.m_strXAxisLabel = "milli" + this.m_strXAxisBaseUnit;
                    this.m_strXAxisLabelShort = "m" + this.m_strXAxisBaseUnitShort;
                    strNextXAxisLabel = this.m_strXAxisBaseUnitShort;
                } else if (dFrameRefX <= 50.0 * GraphControl.UNITS) {
                    dMajorUnitX = 0.1 * GraphControl.UNITS >= dFrameRefX ? 0.1 * GraphControl.UNITS : (0.2 * GraphControl.UNITS >= dFrameRefX ? 0.2 * GraphControl.UNITS : (0.5 * GraphControl.UNITS >= dFrameRefX ? 0.5 * GraphControl.UNITS : (1.0 * GraphControl.UNITS >= dFrameRefX ? 1.0 * GraphControl.UNITS : (2.0 * GraphControl.UNITS >= dFrameRefX ? 2.0 * GraphControl.UNITS : (5.0 * GraphControl.UNITS >= dFrameRefX ? 5.0 * GraphControl.UNITS : (10.0 * GraphControl.UNITS >= dFrameRefX ? 10.0 * GraphControl.UNITS : (20.0 * GraphControl.UNITS >= dFrameRefX ? 20.0 * GraphControl.UNITS : 50.0 * GraphControl.UNITS)))))));
                    this.m_iMajorUnitTypeX = 4;
                    this.m_dMajorUnitXTypeValue = GraphControl.UNITS;
                    this.m_dNextMajorUnitXTypeValue = GraphControl.KILOUNITS;
                    this.m_dNextNextMajorUnitXTypeValue = GraphControl.MEGAUNITS;
                    this.m_strXAxisLabel = this.m_strXAxisBaseUnit;
                    this.m_strXAxisLabelShort = this.m_strXAxisBaseUnitShort;
                    strNextXAxisLabel = "k" + this.m_strXAxisBaseUnitShort;
                } else if (dFrameRefX <= 50.0 * GraphControl.KILOUNITS) {
                    dMajorUnitX = 0.1 * GraphControl.KILOUNITS >= dFrameRefX ? 0.1 * GraphControl.KILOUNITS : (0.2 * GraphControl.KILOUNITS >= dFrameRefX ? 0.2 * GraphControl.KILOUNITS : (0.5 * GraphControl.KILOUNITS >= dFrameRefX ? 0.5 * GraphControl.KILOUNITS : (1.0 * GraphControl.KILOUNITS >= dFrameRefX ? 1.0 * GraphControl.KILOUNITS : (2.0 * GraphControl.KILOUNITS >= dFrameRefX ? 2.0 * GraphControl.KILOUNITS : (5.0 * GraphControl.KILOUNITS >= dFrameRefX ? 5.0 * GraphControl.KILOUNITS : (10.0 * GraphControl.KILOUNITS >= dFrameRefX ? 10.0 * GraphControl.KILOUNITS : (20.0 * GraphControl.KILOUNITS >= dFrameRefX ? 20.0 * GraphControl.KILOUNITS : 50.0 * GraphControl.KILOUNITS)))))));
                    this.m_iMajorUnitTypeX = 5;
                    this.m_dMajorUnitXTypeValue = GraphControl.KILOUNITS;
                    this.m_dNextMajorUnitXTypeValue = GraphControl.MEGAUNITS;
                    this.m_strXAxisLabel = "kilo" + this.m_strXAxisBaseUnit;
                    this.m_strXAxisLabelShort = "k" + this.m_strXAxisBaseUnitShort;
                    strNextXAxisLabel = "M" + this.m_strXAxisBaseUnitShort;
                } else {
                    dMajorUnitX = 0.1 * GraphControl.MEGAUNITS >= dFrameRefX ? 0.1 * GraphControl.MEGAUNITS : (0.2 * GraphControl.MEGAUNITS >= dFrameRefX ? 0.2 * GraphControl.MEGAUNITS : (0.5 * GraphControl.MEGAUNITS >= dFrameRefX ? 0.5 * GraphControl.MEGAUNITS : (1.0 * GraphControl.MEGAUNITS >= dFrameRefX ? 1.0 * GraphControl.MEGAUNITS : (2.0 * GraphControl.MEGAUNITS >= dFrameRefX ? 2.0 * GraphControl.MEGAUNITS : (5.0 * GraphControl.MEGAUNITS >= dFrameRefX ? 5.0 * GraphControl.MEGAUNITS : (10.0 * GraphControl.MEGAUNITS >= dFrameRefX ? 10.0 * GraphControl.MEGAUNITS : (20.0 * GraphControl.MEGAUNITS >= dFrameRefX ? 20.0 * GraphControl.MEGAUNITS : 50.0 * GraphControl.MEGAUNITS)))))));
                    this.m_iMajorUnitTypeX = 6;
                    this.m_dMajorUnitXTypeValue = GraphControl.MEGAUNITS;
                    this.m_strXAxisLabelShort = "M" + this.m_strXAxisBaseUnitShort;
                    this.m_strXAxisLabel = "mega" + this.m_strXAxisBaseUnit;
                }
                iNumXDivisions = (int)(dDifferenceX / dMajorUnitX) + 2;
                xstart = this.m_drectView.left / dMajorUnitX <= this.Floor(this.m_drectView.left / dMajorUnitX) ? this.Floor(this.m_drectView.left / dMajorUnitX) * dMajorUnitX - dMajorUnitX : this.Floor(this.m_drectView.left / dMajorUnitX) * dMajorUnitX;
                pixelMajorUnitX = (int)(dMajorUnitX / this.m_dXMultiplier) + 1;
                iMajorUnitsPerLabelX = metricsXAxisDivision.stringWidth("8888.8") / pixelMajorUnitX + 1;
                i = 0;
                while (i < iNumXDivisions) {
                    xpos = (int)(this.m_rectGraph.left + (double)((int)((xstart - this.m_drectView.left + dMajorUnitX * (double)i) * this.m_dInvXMultiplier)));
                    if ((double)xpos <= this.m_rectGraph.right && (double)xpos >= this.m_rectGraph.left) {
                        dValue = xstart + dMajorUnitX * (double)i;
                        if (this.m_iMajorUnitTypeX == 8) {
                            dBaseValue = 0.0;
                            dNextBaseValue = 0.0;
                        } else if (this.m_iMajorUnitTypeX == 7) {
                            dBaseValue = this.Floor(dValue / this.m_dNextMajorUnitXTypeValue) * this.m_dNextMajorUnitXTypeValue;
                            dNextBaseValue = 0.0;
                        } else {
                            dBaseValue = this.Floor(dValue / this.m_dNextMajorUnitXTypeValue) * this.m_dNextMajorUnitXTypeValue;
                            dNextBaseValue = this.Floor(dValue / this.m_dNextNextMajorUnitXTypeValue) * this.m_dNextNextMajorUnitXTypeValue;
                        }
                        dDisplayValue = (dValue - dBaseValue) / this.m_dMajorUnitXTypeValue;
                        dNextDisplayValue = (dValue - dNextBaseValue) / this.m_dNextMajorUnitXTypeValue;
                        if (dDisplayValue == 0.0) {
                            gl.glColor3f(0.2f, 0.2f, 0.2f);
                            gl.glBegin(1);
                            gl.glVertex2i(xpos, (int)(this.m_rectGraph.bottom - (double)GREAT_LINE_LENGTH));
                            gl.glVertex2i(xpos, (int)this.m_rectGraph.bottom);
                            gl.glEnd();
                            str = decformat.format(dNextDisplayValue);
                            if (dValue != 0.0) {
                                str = String.valueOf(str) + " " + strNextXAxisLabel;
                            }
                            this.printGL(this.m_rendererXAxisDivision, xpos, (int)this.m_rectGraph.bottom - GREAT_LINE_LENGTH - metricsXAxisDivision.getAscent() - 2, GraphControl.JUSTIFY_CENTER, 0.0f, str);
                        } else {
                            x2 = dValue / dMajorUnitX / (double)iMajorUnitsPerLabelX;
                            x3 = this.Floor(x2);
                            if (x2 == x3) {
                                str = decformat.format(dDisplayValue);
                                this.printGL(this.m_rendererXAxisDivision, xpos, (int)this.m_rectGraph.bottom - MAJOR_LINE_LENGTH - metricsXAxisDivision.getAscent() - 2, GraphControl.JUSTIFY_CENTER, 0.0f, str);
                            }
                            gl.glColor3f(0.2f, 0.2f, 0.2f);
                            gl.glBegin(1);
                            gl.glVertex2i(xpos, (int)(this.m_rectGraph.bottom - (double)MAJOR_LINE_LENGTH));
                            gl.glVertex2i(xpos, (int)this.m_rectGraph.bottom);
                            gl.glEnd();
                        }
                        gl.glColor3f(0.8627451f, 0.8627451f, 0.8627451f);
                        gl.glBegin(1);
                        gl.glVertex2i(xpos, (int)this.m_rectGraph.bottom);
                        gl.glVertex2i(xpos, (int)this.m_rectGraph.top);
                        gl.glEnd();
                    }
                    gl.glColor3f(0.2f, 0.2f, 0.2f);
                    j = 1;
                    while (j < 5) {
                        extraxpos = (int)(dMajorUnitX * ((double)j / 5.0) * this.m_dInvXMultiplier);
                        if ((double)(xpos + extraxpos) <= this.m_rectGraph.right && (double)(xpos + extraxpos) >= this.m_rectGraph.left) {
                            gl.glBegin(1);
                            gl.glVertex2i(xpos + extraxpos, (int)(this.m_rectGraph.bottom - (double)MINOR_LINE_LENGTH));
                            gl.glVertex2i(xpos + extraxpos, (int)this.m_rectGraph.bottom);
                            gl.glEnd();
                        }
                        ++j;
                    }
                    ++i;
                }
                leftneg = false;
                rightneg = false;
                strTopLeft = "";
                strTopRight = "";
                strBottomLeft = "";
                strBottomRight = "";
                if (!this.m_bXAxisIsTime) break block140;
                switch (this.m_iMajorUnitTypeX) {
                    case 1: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.MILLISECONDS) * GraphControl.MILLISECONDS) / GraphControl.MICROSECONDS);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.MILLISECONDS) * GraphControl.MILLISECONDS) / GraphControl.MICROSECONDS);
                        if (leftvalue < 0) {
                            leftvalue = Math.abs(leftvalue);
                            leftneg = true;
                        }
                        if (rightvalue < 0) {
                            rightvalue = Math.abs(rightvalue);
                            rightneg = true;
                        }
                        strBottomLeft = String.format(".%03d", new Object[]{leftvalue});
                        strBottomRight = String.format(".%03d", new Object[]{rightvalue});
                    }
                    case 2: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.SECONDS) * GraphControl.SECONDS) / GraphControl.MILLISECONDS);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.SECONDS) * GraphControl.SECONDS) / GraphControl.MILLISECONDS);
                        if (leftvalue < 0) {
                            leftvalue = Math.abs(leftvalue);
                            leftneg = true;
                        }
                        if (rightvalue < 0) {
                            rightvalue = Math.abs(rightvalue);
                            rightneg = true;
                        }
                        strBottomLeft = String.valueOf(String.format(".%03d", new Object[]{leftvalue})) + strBottomLeft;
                        strBottomRight = String.valueOf(String.format(".%03d", new Object[]{rightvalue})) + strBottomRight;
                    }
                    case 3: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.MINUTES) * GraphControl.MINUTES) / GraphControl.SECONDS);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.MINUTES) * GraphControl.MINUTES) / GraphControl.SECONDS);
                        if (leftvalue < 0) {
                            leftvalue = Math.abs(leftvalue);
                            leftneg = true;
                        }
                        if (rightvalue < 0) {
                            rightvalue = Math.abs(rightvalue);
                            rightneg = true;
                        }
                        strBottomLeft = String.valueOf(String.format(":%02d", new Object[]{leftvalue})) + strBottomLeft;
                        strBottomRight = String.valueOf(String.format(":%02d", new Object[]{rightvalue})) + strBottomRight;
                    }
                    case 4: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.HOURS) * GraphControl.HOURS) / GraphControl.MINUTES);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.HOURS) * GraphControl.HOURS) / GraphControl.MINUTES);
                        if (leftvalue < 0) {
                            leftvalue = Math.abs(leftvalue);
                            leftneg = true;
                        }
                        if (rightvalue < 0) {
                            rightvalue = Math.abs(rightvalue);
                            rightneg = true;
                        }
                        strBottomLeft = String.valueOf(String.format(":%02d", new Object[]{leftvalue})) + strBottomLeft;
                        strBottomRight = String.valueOf(String.format(":%02d", new Object[]{rightvalue})) + strBottomRight;
                    }
                    case 5: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.DAYS) * GraphControl.DAYS) / GraphControl.HOURS);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.DAYS) * GraphControl.DAYS) / GraphControl.HOURS);
                        if (this.m_iMajorUnitTypeX != 5) ** GOTO lbl281
                        strBottomLeft = String.format("Hour %d", new Object[]{leftvalue});
                        strBottomRight = String.format("Hour %d", new Object[]{rightvalue});
                        ** GOTO lbl293
lbl281:
                        // 1 sources

                        if (leftvalue < 0) {
                            leftvalue = Math.abs(leftvalue);
                            leftneg = true;
                        }
                        if (rightvalue < 0) {
                            rightvalue = Math.abs(rightvalue);
                            rightneg = true;
                        }
                        strBottomLeft = String.valueOf(String.format("%02d", new Object[]{leftvalue})) + strBottomLeft;
                        strBottomRight = String.valueOf(String.format("%02d", new Object[]{rightvalue})) + strBottomRight;
                        if (leftneg) {
                            strBottomLeft = "-" + strBottomLeft;
                        }
                        if (rightneg) {
                            strBottomRight = "-" + strBottomRight;
                        }
                    }
lbl293:
                    // 5 sources

                    case 6: {
                        leftvalue = (int)((this.m_drectView.left - this.Floor(this.m_drectView.left / GraphControl.YEARS) * GraphControl.YEARS) / GraphControl.DAYS);
                        rightvalue = (int)((this.m_drectView.right - this.Floor(this.m_drectView.right / GraphControl.YEARS) * GraphControl.YEARS) / GraphControl.DAYS);
                        strTopLeft = String.format("Day %d", new Object[]{leftvalue});
                        strTopRight = String.format("Day %d", new Object[]{rightvalue});
                    }
                    case 7: {
                        leftvalue = (int)this.Floor(this.m_drectView.left / GraphControl.YEARS);
                        rightvalue = (int)this.Floor(this.m_drectView.right / GraphControl.YEARS);
                        if (this.m_iMajorUnitTypeX != 7) break block141;
                        strTopLeft = "";
                        strTopRight = "";
                    }
                    default: {
                        ** break;
                    }
                    {
lbl307:
                        // 1 sources

                        break block141;
                    }
                }
            }
            switch (this.m_iMajorUnitTypeX) {
                case 1: {
                    leftvalue = (int)((this.m_drectView.top - this.Floor(this.m_drectView.top / GraphControl.MILLIUNITS) * GraphControl.MILLIUNITS) / GraphControl.MICROUNITS);
                    rightvalue = (int)((this.m_drectView.bottom - this.Floor(this.m_drectView.bottom / GraphControl.MILLIUNITS) * GraphControl.MILLIUNITS) / GraphControl.MICROUNITS);
                    if (leftvalue < 0) {
                        leftvalue = Math.abs(leftvalue);
                        leftneg = true;
                    }
                    if (rightvalue < 0) {
                        rightvalue = Math.abs(rightvalue);
                        rightneg = true;
                    }
                    strBottomLeft = String.valueOf(String.format(" %03d", new Object[]{leftvalue})) + strBottomLeft;
                    strBottomRight = String.valueOf(String.format(" %03d", new Object[]{rightvalue})) + strBottomRight;
                }
                case 2: {
                    leftvalue = (int)((this.m_drectView.top - this.Floor(this.m_drectView.top / GraphControl.UNITS) * GraphControl.UNITS) / GraphControl.MILLIUNITS);
                    rightvalue = (int)((this.m_drectView.bottom - this.Floor(this.m_drectView.bottom / GraphControl.UNITS) * GraphControl.UNITS) / GraphControl.MILLIUNITS);
                    if (leftvalue < 0) {
                        leftvalue = Math.abs(leftvalue);
                        leftneg = true;
                    }
                    if (rightvalue < 0) {
                        rightvalue = Math.abs(rightvalue);
                        rightneg = true;
                    }
                    strBottomLeft = String.valueOf(String.format(".%03d", new Object[]{leftvalue})) + strBottomLeft;
                    strBottomRight = String.valueOf(String.format(".%03d", new Object[]{rightvalue})) + strBottomRight;
                }
                case 3: {
                    leftvalue = (int)this.Floor(this.m_drectView.top / GraphControl.UNITS);
                    rightvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.UNITS);
                    if (leftvalue < 0) {
                        leftvalue = Math.abs(leftvalue);
                        leftneg = true;
                    }
                    if (rightvalue < 0) {
                        rightvalue = Math.abs(rightvalue);
                        rightneg = true;
                    }
                    strBottomLeft = String.valueOf(String.format("%d", new Object[]{leftvalue})) + strBottomLeft + " " + this.m_strYAxisBaseUnitShort;
                    strBottomRight = String.valueOf(String.format("%d", new Object[]{rightvalue})) + strBottomRight + " " + this.m_strYAxisBaseUnitShort;
                    if (leftneg) {
                        strBottomLeft = "-" + strBottomLeft;
                    }
                    if (!rightneg) break;
                    strBottomRight = "-" + strBottomRight;
                    break;
                }
                case 4: {
                    leftvalue = (int)this.Floor(this.m_drectView.top / GraphControl.KILOUNITS);
                    rightvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.KILOUNITS);
                    strBottomLeft = String.valueOf(String.format("%d", new Object[]{leftvalue})) + strBottomLeft + " k" + this.m_strYAxisBaseUnitShort;
                    strBottomRight = String.valueOf(String.format("%d", new Object[]{rightvalue})) + strBottomRight + " k" + this.m_strYAxisBaseUnitShort;
                    break;
                }
                case 5: {
                    leftvalue = (int)this.Floor(this.m_drectView.top / GraphControl.MEGAUNITS);
                    rightvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.MEGAUNITS);
                    strBottomLeft = String.valueOf(String.format("%d", new Object[]{leftvalue})) + strBottomLeft + " M" + this.m_strYAxisBaseUnitShort;
                    strBottomRight = String.valueOf(String.format("%d", new Object[]{rightvalue})) + strBottomRight + " M" + this.m_strYAxisBaseUnitShort;
                }
            }
        }
        if (this.m_bXAxisRangeIndicatorsVisible) {
            if (this.m_bXAxisIsTime) {
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.left, (int)(rectWindow.bottom + (double)metricsXAxisDivision.getHeight() + 2.0), GraphControl.JUSTIFY_LEFT, 0.0f, strTopLeft);
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.right, (int)(rectWindow.bottom + (double)metricsXAxisDivision.getHeight() + 2.0), GraphControl.JUSTIFY_RIGHT, 0.0f, strTopRight);
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.left, (int)(rectWindow.bottom + 2.0), GraphControl.JUSTIFY_LEFT, 0.0f, strBottomLeft);
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.right, (int)(rectWindow.bottom + 2.0), GraphControl.JUSTIFY_RIGHT, 0.0f, strBottomRight);
            } else {
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.left, (int)(rectWindow.bottom + (double)metricsXAxisDivision.getHeight() + 2.0), GraphControl.JUSTIFY_LEFT, 0.0f, strBottomLeft);
                this.printGL(this.m_rendererXAxisDivision, (int)this.m_rectGraph.right, (int)(rectWindow.bottom + (double)metricsXAxisDivision.getHeight() + 2.0), GraphControl.JUSTIFY_RIGHT, 0.0f, strBottomRight);
            }
        }
        dFrameRefY = 20.0 * this.m_dYMultiplier;
        dDifferenceY = this.m_drectView.top - this.m_drectView.bottom;
        if (dFrameRefY <= 50.0 * GraphControl.NANOUNITS) {
            dMajorUnitY = 1.0 >= dFrameRefY ? 1.0 : (2.0 >= dFrameRefY ? 2.0 : (5.0 >= dFrameRefY ? 5.0 : (10.0 >= dFrameRefY ? 10.0 : (20.0 >= dFrameRefY ? 20.0 : 50.0))));
            this.m_iMajorUnitTypeY = 1;
            this.m_dMajorUnitYTypeValue = GraphControl.NANOUNITS;
            this.m_dNextMajorUnitYTypeValue = GraphControl.MICROUNITS;
            this.m_dNextNextMajorUnitYTypeValue = GraphControl.MILLIUNITS;
            this.m_strYAxisLabel = "nano" + this.m_strYAxisBaseUnit;
            this.m_strYAxisLabelShort = "n" + this.m_strYAxisBaseUnitShort;
            strNextYAxisLabel = "\u03bc" + this.m_strYAxisBaseUnitShort;
        } else if (dFrameRefY <= 50.0 * GraphControl.MICROUNITS) {
            dMajorUnitY = 0.1 * GraphControl.MICROUNITS >= dFrameRefY ? 0.1 * GraphControl.MICROUNITS : (0.2 * GraphControl.MICROUNITS >= dFrameRefY ? 0.2 * GraphControl.MICROUNITS : (0.5 * GraphControl.MICROUNITS >= dFrameRefY ? 0.5 * GraphControl.MICROUNITS : (1.0 * GraphControl.MICROUNITS >= dFrameRefY ? 1.0 * GraphControl.MICROUNITS : (2.0 * GraphControl.MICROUNITS >= dFrameRefY ? 2.0 * GraphControl.MICROUNITS : (5.0 * GraphControl.MICROUNITS >= dFrameRefY ? 5.0 * GraphControl.MICROUNITS : (10.0 * GraphControl.MICROUNITS >= dFrameRefY ? 10.0 * GraphControl.MICROUNITS : (20.0 * GraphControl.MICROUNITS >= dFrameRefY ? 20.0 * GraphControl.MICROUNITS : 50.0 * GraphControl.MICROUNITS)))))));
            this.m_iMajorUnitTypeY = 2;
            this.m_dMajorUnitYTypeValue = GraphControl.MICROUNITS;
            this.m_dNextMajorUnitYTypeValue = GraphControl.MILLIUNITS;
            this.m_dNextNextMajorUnitYTypeValue = GraphControl.UNITS;
            this.m_strYAxisLabel = "micro" + this.m_strYAxisBaseUnit;
            this.m_strYAxisLabelShort = "\u03bc" + this.m_strYAxisBaseUnitShort;
            strNextYAxisLabel = "m" + this.m_strYAxisBaseUnitShort;
        } else if (dFrameRefY <= 50.0 * GraphControl.MILLIUNITS) {
            dMajorUnitY = 0.1 * GraphControl.MILLIUNITS >= dFrameRefY ? 0.1 * GraphControl.MILLIUNITS : (0.2 * GraphControl.MILLIUNITS >= dFrameRefY ? 0.2 * GraphControl.MILLIUNITS : (0.5 * GraphControl.MILLIUNITS >= dFrameRefY ? 0.5 * GraphControl.MILLIUNITS : (1.0 * GraphControl.MILLIUNITS >= dFrameRefY ? 1.0 * GraphControl.MILLIUNITS : (2.0 * GraphControl.MILLIUNITS >= dFrameRefY ? 2.0 * GraphControl.MILLIUNITS : (5.0 * GraphControl.MILLIUNITS >= dFrameRefY ? 5.0 * GraphControl.MILLIUNITS : (10.0 * GraphControl.MILLIUNITS >= dFrameRefY ? 10.0 * GraphControl.MILLIUNITS : (20.0 * GraphControl.MILLIUNITS >= dFrameRefY ? 20.0 * GraphControl.MILLIUNITS : 50.0 * GraphControl.MILLIUNITS)))))));
            this.m_iMajorUnitTypeY = 3;
            this.m_dMajorUnitYTypeValue = GraphControl.MILLIUNITS;
            this.m_dNextMajorUnitYTypeValue = GraphControl.UNITS;
            this.m_dNextNextMajorUnitYTypeValue = GraphControl.KILOUNITS;
            this.m_strYAxisLabel = "milli" + this.m_strYAxisBaseUnit;
            this.m_strYAxisLabelShort = "m" + this.m_strYAxisBaseUnitShort;
            strNextYAxisLabel = this.m_strYAxisBaseUnitShort;
        } else if (dFrameRefY <= 50.0 * GraphControl.UNITS) {
            dMajorUnitY = 0.1 * GraphControl.UNITS >= dFrameRefY ? 0.1 * GraphControl.UNITS : (0.2 * GraphControl.UNITS >= dFrameRefY ? 0.2 * GraphControl.UNITS : (0.5 * GraphControl.UNITS >= dFrameRefY ? 0.5 * GraphControl.UNITS : (1.0 * GraphControl.UNITS >= dFrameRefY ? 1.0 * GraphControl.UNITS : (2.0 * GraphControl.UNITS >= dFrameRefY ? 2.0 * GraphControl.UNITS : (5.0 * GraphControl.UNITS >= dFrameRefY ? 5.0 * GraphControl.UNITS : (10.0 * GraphControl.UNITS >= dFrameRefY ? 10.0 * GraphControl.UNITS : (20.0 * GraphControl.UNITS >= dFrameRefY ? 20.0 * GraphControl.UNITS : 50.0 * GraphControl.UNITS)))))));
            this.m_iMajorUnitTypeY = 4;
            this.m_dMajorUnitYTypeValue = GraphControl.UNITS;
            this.m_dNextMajorUnitYTypeValue = GraphControl.KILOUNITS;
            this.m_dNextNextMajorUnitYTypeValue = GraphControl.MEGAUNITS;
            this.m_strYAxisLabel = this.m_strYAxisBaseUnit;
            this.m_strYAxisLabelShort = this.m_strYAxisBaseUnitShort;
            strNextYAxisLabel = "k" + this.m_strYAxisBaseUnitShort;
        } else if (dFrameRefY <= 50.0 * GraphControl.KILOUNITS) {
            dMajorUnitY = 0.1 * GraphControl.KILOUNITS >= dFrameRefY ? 0.1 * GraphControl.KILOUNITS : (0.2 * GraphControl.KILOUNITS >= dFrameRefY ? 0.2 * GraphControl.KILOUNITS : (0.5 * GraphControl.KILOUNITS >= dFrameRefY ? 0.5 * GraphControl.KILOUNITS : (1.0 * GraphControl.KILOUNITS >= dFrameRefY ? 1.0 * GraphControl.KILOUNITS : (2.0 * GraphControl.KILOUNITS >= dFrameRefY ? 2.0 * GraphControl.KILOUNITS : (5.0 * GraphControl.KILOUNITS >= dFrameRefY ? 5.0 * GraphControl.KILOUNITS : (10.0 * GraphControl.KILOUNITS >= dFrameRefY ? 10.0 * GraphControl.KILOUNITS : (20.0 * GraphControl.KILOUNITS >= dFrameRefY ? 20.0 * GraphControl.KILOUNITS : 50.0 * GraphControl.KILOUNITS)))))));
            this.m_iMajorUnitTypeY = 5;
            this.m_dMajorUnitYTypeValue = GraphControl.KILOUNITS;
            this.m_dNextMajorUnitYTypeValue = GraphControl.MEGAUNITS;
            this.m_strYAxisLabel = "kilo" + this.m_strYAxisBaseUnit;
            this.m_strYAxisLabelShort = "k" + this.m_strYAxisBaseUnitShort;
            strNextYAxisLabel = "M" + this.m_strYAxisBaseUnitShort;
        } else {
            dMajorUnitY = 0.1 * GraphControl.MEGAUNITS >= dFrameRefY ? 0.1 * GraphControl.MEGAUNITS : (0.2 * GraphControl.MEGAUNITS >= dFrameRefY ? 0.2 * GraphControl.MEGAUNITS : (0.5 * GraphControl.MEGAUNITS >= dFrameRefY ? 0.5 * GraphControl.MEGAUNITS : (1.0 * GraphControl.MEGAUNITS >= dFrameRefY ? 1.0 * GraphControl.MEGAUNITS : (2.0 * GraphControl.MEGAUNITS >= dFrameRefY ? 2.0 * GraphControl.MEGAUNITS : (5.0 * GraphControl.MEGAUNITS >= dFrameRefY ? 5.0 * GraphControl.MEGAUNITS : (10.0 * GraphControl.MEGAUNITS >= dFrameRefY ? 10.0 * GraphControl.MEGAUNITS : (20.0 * GraphControl.MEGAUNITS >= dFrameRefY ? 20.0 * GraphControl.MEGAUNITS : 50.0 * GraphControl.MEGAUNITS)))))));
            this.m_iMajorUnitTypeY = 6;
            this.m_dMajorUnitYTypeValue = GraphControl.MEGAUNITS;
            this.m_strYAxisLabelShort = "M" + this.m_strYAxisBaseUnitShort;
            this.m_strYAxisLabel = "mega" + this.m_strYAxisBaseUnit;
        }
        iNumYDivisions = (int)(dDifferenceY / dMajorUnitY) + 2;
        ystart = this.m_drectView.bottom / dMajorUnitY <= this.Floor(this.m_drectView.bottom / dMajorUnitY) ? this.Floor(this.m_drectView.bottom / dMajorUnitY) * dMajorUnitY - dMajorUnitY : this.Floor(this.m_drectView.bottom / dMajorUnitY) * dMajorUnitY;
        pixelMajorUnitY = (int)(dMajorUnitY / this.m_dYMultiplier) + 1;
        iMajorUnitsPerLabelY = metricsYAxisDivision.stringWidth("8888.8") / pixelMajorUnitY + 1;
        i = 0;
        while (i < iNumYDivisions) {
            ypos = (int)this.m_rectGraph.bottom + (int)((ystart - this.m_drectView.bottom + dMajorUnitY * (double)i) * this.m_dInvYMultiplier);
            if ((double)ypos >= this.m_rectGraph.bottom && (double)ypos <= this.m_rectGraph.top) {
                dValue = ystart + dMajorUnitY * (double)i;
                if (this.m_iMajorUnitTypeY == 6) {
                    dBaseValue = 0.0;
                    dNextBaseValue = 0.0;
                } else if (this.m_iMajorUnitTypeY == 5) {
                    dBaseValue = this.Floor(dValue / this.m_dNextMajorUnitYTypeValue) * this.m_dNextMajorUnitYTypeValue;
                    dNextBaseValue = 0.0;
                } else {
                    dBaseValue = this.Floor(dValue / this.m_dNextMajorUnitYTypeValue) * this.m_dNextMajorUnitYTypeValue;
                    dNextBaseValue = this.Floor(dValue / this.m_dNextNextMajorUnitYTypeValue) * this.m_dNextNextMajorUnitYTypeValue;
                }
                dDisplayValue = (dValue - dBaseValue) / this.m_dMajorUnitYTypeValue;
                dNextDisplayValue = (dValue - dNextBaseValue) / this.m_dNextMajorUnitYTypeValue;
                if (dDisplayValue == 0.0) {
                    gl.glColor3f(0.2f, 0.2f, 0.2f);
                    gl.glBegin(1);
                    gl.glVertex2i((int)(this.m_rectGraph.left - (double)GREAT_LINE_LENGTH), ypos);
                    gl.glVertex2i((int)this.m_rectGraph.left, ypos);
                    gl.glEnd();
                    str = decformat.format(dNextDisplayValue);
                    if (dValue != 0.0) {
                        str = String.valueOf(str) + strNextYAxisLabel;
                    }
                    this.printGL(this.m_rendererYAxisDivision, (int)(this.m_rectGraph.left - (double)GREAT_LINE_LENGTH - 2.0), ypos, GraphControl.JUSTIFY_CENTER, 90.0f, str);
                } else {
                    x2 = dValue / dMajorUnitY / (double)iMajorUnitsPerLabelY;
                    x3 = this.Floor(x2);
                    if (x2 == x3) {
                        str = decformat.format(dDisplayValue);
                        this.printGL(this.m_rendererYAxisDivision, (int)(this.m_rectGraph.left - (double)MAJOR_LINE_LENGTH - 2.0), ypos, GraphControl.JUSTIFY_CENTER, 90.0f, str);
                    }
                    gl.glColor3f(0.2f, 0.2f, 0.2f);
                    gl.glBegin(1);
                    gl.glVertex2i((int)(this.m_rectGraph.left - (double)MAJOR_LINE_LENGTH), ypos);
                    gl.glVertex2i((int)this.m_rectGraph.left, ypos);
                    gl.glEnd();
                }
                gl.glColor3f(0.8627451f, 0.8627451f, 0.8627451f);
                gl.glBegin(1);
                gl.glVertex2i((int)this.m_rectGraph.left, ypos);
                gl.glVertex2i((int)this.m_rectGraph.right, ypos);
                gl.glEnd();
            }
            gl.glColor3f(0.2f, 0.2f, 0.2f);
            j = 1;
            while (j < 5) {
                extraypos = (int)(dMajorUnitY * ((double)j / 5.0) * this.m_dInvYMultiplier);
                if ((double)(ypos + extraypos) >= this.m_rectGraph.bottom && (double)(ypos + extraypos) <= this.m_rectGraph.top) {
                    gl.glBegin(1);
                    gl.glVertex2i((int)(this.m_rectGraph.left - (double)MINOR_LINE_LENGTH), ypos + extraypos);
                    gl.glVertex2i((int)this.m_rectGraph.left, ypos + extraypos);
                    gl.glEnd();
                }
                ++j;
            }
            ++i;
        }
        topneg = false;
        bottomneg = false;
        strTop = "";
        strBottom = "";
        switch (this.m_iMajorUnitTypeY) {
            case 1: {
                topvalue = (int)((this.m_drectView.top - this.Floor(this.m_drectView.top / GraphControl.MILLIUNITS) * GraphControl.MILLIUNITS) / GraphControl.MICROUNITS);
                bottomvalue = (int)((this.m_drectView.bottom - this.Floor(this.m_drectView.bottom / GraphControl.MILLIUNITS) * GraphControl.MILLIUNITS) / GraphControl.MICROUNITS);
                if (topvalue < 0) {
                    topvalue = Math.abs(topvalue);
                    topneg = true;
                }
                if (bottomvalue < 0) {
                    bottomvalue = Math.abs(bottomvalue);
                    bottomneg = true;
                }
                strTop = String.valueOf(String.format(" %03d", new Object[]{topvalue})) + strTop;
                strBottom = String.valueOf(String.format(" %03d", new Object[]{bottomvalue})) + strBottom;
            }
            case 2: {
                topvalue = (int)((this.m_drectView.top - this.Floor(this.m_drectView.top / GraphControl.UNITS) * GraphControl.UNITS) / GraphControl.MILLIUNITS);
                bottomvalue = (int)((this.m_drectView.bottom - this.Floor(this.m_drectView.bottom / GraphControl.UNITS) * GraphControl.UNITS) / GraphControl.MILLIUNITS);
                if (topvalue < 0) {
                    topvalue = Math.abs(topvalue);
                    topneg = true;
                }
                if (bottomvalue < 0) {
                    bottomvalue = Math.abs(bottomvalue);
                    bottomneg = true;
                }
                strTop = String.valueOf(String.format(".%03d", new Object[]{topvalue})) + strTop;
                strBottom = String.valueOf(String.format(".%03d", new Object[]{bottomvalue})) + strBottom;
            }
            case 3: {
                topvalue = (int)this.Floor(this.m_drectView.top / GraphControl.UNITS);
                bottomvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.UNITS);
                if (topvalue < 0) {
                    topvalue = Math.abs(topvalue);
                    topneg = true;
                }
                if (bottomvalue < 0) {
                    bottomvalue = Math.abs(bottomvalue);
                    bottomneg = true;
                }
                strTop = String.valueOf(String.format("%d", new Object[]{topvalue})) + strTop + " " + this.m_strYAxisBaseUnitShort;
                strBottom = String.valueOf(String.format("%d", new Object[]{bottomvalue})) + strBottom + " " + this.m_strYAxisBaseUnitShort;
                if (topneg) {
                    strTop = "-" + strTop;
                }
                if (!bottomneg) break;
                strBottom = "-" + strBottom;
                break;
            }
            case 4: {
                topvalue = (int)this.Floor(this.m_drectView.top / GraphControl.KILOUNITS);
                bottomvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.KILOUNITS);
                strTop = String.valueOf(String.format("%d", new Object[]{topvalue})) + strTop + " k" + this.m_strYAxisBaseUnitShort;
                strBottom = String.valueOf(String.format("%d", new Object[]{bottomvalue})) + strBottom + " k" + this.m_strYAxisBaseUnitShort;
                break;
            }
            case 5: {
                topvalue = (int)this.Floor(this.m_drectView.top / GraphControl.MEGAUNITS);
                bottomvalue = (int)this.Floor(this.m_drectView.bottom / GraphControl.MEGAUNITS);
                strTop = String.valueOf(String.format("%d", new Object[]{topvalue})) + strTop + " M" + this.m_strYAxisBaseUnitShort;
                strBottom = String.valueOf(String.format("%d", new Object[]{bottomvalue})) + strBottom + " M" + this.m_strYAxisBaseUnitShort;
            }
        }
        if (this.m_bYAxisRangeIndicatorsVisible) {
            this.printGL(this.m_rendererYAxisDivision, (int)(rectWindow.left + 2.0 + (double)metricsYAxisLabel.getHeight() + (double)metricsYAxisDivision.getHeight()), (int)this.m_rectGraph.bottom, GraphControl.JUSTIFY_LEFT, 90.0f, strBottom);
            this.printGL(this.m_rendererYAxisDivision, (int)(rectWindow.left + 2.0 + (double)metricsYAxisLabel.getHeight() + (double)metricsYAxisDivision.getHeight()), (int)this.m_rectGraph.top, GraphControl.JUSTIFY_RIGHT, 90.0f, strTop);
        }
        if (this.m_bSecondYAxisVisible) {
            dSecondFrameRefY = 20.0 * this.m_dSecondYMultiplier;
            dSecondDifferenceY = this.m_dSecondYAxisUpperLimit - this.m_dSecondYAxisLowerLimit;
            if (dSecondFrameRefY <= 50.0 * GraphControl.NANOUNITS) {
                dSecondMajorUnitY = 1.0 >= dSecondFrameRefY ? 1.0 : (2.0 >= dSecondFrameRefY ? 2.0 : (5.0 >= dSecondFrameRefY ? 5.0 : (10.0 >= dSecondFrameRefY ? 10.0 : (20.0 >= dSecondFrameRefY ? 20.0 : 50.0))));
                this.m_iSecondMajorUnitTypeY = 1;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.NANOUNITS;
                this.m_dSecondNextMajorUnitYTypeValue = GraphControl.MICROUNITS;
                this.m_dSecondNextNextMajorUnitYTypeValue = GraphControl.MILLIUNITS;
                this.m_strSecondYAxisLabel = "nano" + this.m_strSecondYAxisBaseUnit;
                this.m_strSecondYAxisLabelShort = "n" + this.m_strSecondYAxisBaseUnitShort;
                strSecondNextYAxisLabel = "\u03bc" + this.m_strSecondYAxisBaseUnitShort;
            } else if (dSecondFrameRefY <= 50.0 * GraphControl.MICROUNITS) {
                dSecondMajorUnitY = 0.1 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 0.1 * GraphControl.MICROUNITS : (0.2 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 0.2 * GraphControl.MICROUNITS : (0.5 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 0.5 * GraphControl.MICROUNITS : (1.0 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 1.0 * GraphControl.MICROUNITS : (2.0 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 2.0 * GraphControl.MICROUNITS : (5.0 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 5.0 * GraphControl.MICROUNITS : (10.0 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 10.0 * GraphControl.MICROUNITS : (20.0 * GraphControl.MICROUNITS >= dSecondFrameRefY ? 20.0 * GraphControl.MICROUNITS : 50.0 * GraphControl.MICROUNITS)))))));
                this.m_iSecondMajorUnitTypeY = 2;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.MICROUNITS;
                this.m_dSecondNextMajorUnitYTypeValue = GraphControl.MILLIUNITS;
                this.m_dSecondNextNextMajorUnitYTypeValue = GraphControl.UNITS;
                this.m_strSecondYAxisLabel = "micro" + this.m_strSecondYAxisBaseUnit;
                this.m_strSecondYAxisLabelShort = "\u03bc" + this.m_strSecondYAxisBaseUnitShort;
                strSecondNextYAxisLabel = "m" + this.m_strSecondYAxisBaseUnitShort;
            } else if (dSecondFrameRefY <= 50.0 * GraphControl.MILLIUNITS) {
                dSecondMajorUnitY = 0.1 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 0.1 * GraphControl.MILLIUNITS : (0.2 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 0.2 * GraphControl.MILLIUNITS : (0.5 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 0.5 * GraphControl.MILLIUNITS : (1.0 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 1.0 * GraphControl.MILLIUNITS : (2.0 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 2.0 * GraphControl.MILLIUNITS : (5.0 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 5.0 * GraphControl.MILLIUNITS : (10.0 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 10.0 * GraphControl.MILLIUNITS : (20.0 * GraphControl.MILLIUNITS >= dSecondFrameRefY ? 20.0 * GraphControl.MILLIUNITS : 50.0 * GraphControl.MILLIUNITS)))))));
                this.m_iSecondMajorUnitTypeY = 3;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.MILLIUNITS;
                this.m_dSecondNextMajorUnitYTypeValue = GraphControl.UNITS;
                this.m_dSecondNextNextMajorUnitYTypeValue = GraphControl.KILOUNITS;
                this.m_strSecondYAxisLabel = "milli" + this.m_strSecondYAxisBaseUnit;
                this.m_strSecondYAxisLabelShort = "m" + this.m_strSecondYAxisBaseUnitShort;
                strSecondNextYAxisLabel = this.m_strSecondYAxisBaseUnitShort;
            } else if (dSecondFrameRefY <= 50.0 * GraphControl.UNITS) {
                dSecondMajorUnitY = 0.1 * GraphControl.UNITS >= dSecondFrameRefY ? 0.1 * GraphControl.UNITS : (0.2 * GraphControl.UNITS >= dSecondFrameRefY ? 0.2 * GraphControl.UNITS : (0.5 * GraphControl.UNITS >= dSecondFrameRefY ? 0.5 * GraphControl.UNITS : (1.0 * GraphControl.UNITS >= dSecondFrameRefY ? 1.0 * GraphControl.UNITS : (2.0 * GraphControl.UNITS >= dSecondFrameRefY ? 2.0 * GraphControl.UNITS : (5.0 * GraphControl.UNITS >= dSecondFrameRefY ? 5.0 * GraphControl.UNITS : (10.0 * GraphControl.UNITS >= dSecondFrameRefY ? 10.0 * GraphControl.UNITS : (20.0 * GraphControl.UNITS >= dSecondFrameRefY ? 20.0 * GraphControl.UNITS : 50.0 * GraphControl.UNITS)))))));
                this.m_iSecondMajorUnitTypeY = 4;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.UNITS;
                this.m_dSecondNextMajorUnitYTypeValue = GraphControl.KILOUNITS;
                this.m_dSecondNextNextMajorUnitYTypeValue = GraphControl.MEGAUNITS;
                this.m_strSecondYAxisLabel = this.m_strSecondYAxisBaseUnit;
                this.m_strSecondYAxisLabelShort = this.m_strSecondYAxisBaseUnitShort;
                strSecondNextYAxisLabel = "k" + this.m_strSecondYAxisBaseUnitShort;
            } else if (dSecondFrameRefY <= 50.0 * GraphControl.KILOUNITS) {
                dSecondMajorUnitY = 0.1 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 0.1 * GraphControl.KILOUNITS : (0.2 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 0.2 * GraphControl.KILOUNITS : (0.5 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 0.5 * GraphControl.KILOUNITS : (1.0 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 1.0 * GraphControl.KILOUNITS : (2.0 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 2.0 * GraphControl.KILOUNITS : (5.0 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 5.0 * GraphControl.KILOUNITS : (10.0 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 10.0 * GraphControl.KILOUNITS : (20.0 * GraphControl.KILOUNITS >= dSecondFrameRefY ? 20.0 * GraphControl.KILOUNITS : 50.0 * GraphControl.KILOUNITS)))))));
                this.m_iSecondMajorUnitTypeY = 5;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.KILOUNITS;
                this.m_dSecondNextMajorUnitYTypeValue = GraphControl.MEGAUNITS;
                this.m_strSecondYAxisLabel = "kilo" + this.m_strSecondYAxisBaseUnit;
                this.m_strSecondYAxisLabelShort = "k" + this.m_strSecondYAxisBaseUnitShort;
                strSecondNextYAxisLabel = "M" + this.m_strSecondYAxisBaseUnitShort;
            } else {
                dSecondMajorUnitY = 0.1 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 0.1 * GraphControl.MEGAUNITS : (0.2 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 0.2 * GraphControl.MEGAUNITS : (0.5 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 0.5 * GraphControl.MEGAUNITS : (1.0 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 1.0 * GraphControl.MEGAUNITS : (2.0 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 2.0 * GraphControl.MEGAUNITS : (5.0 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 5.0 * GraphControl.MEGAUNITS : (10.0 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 10.0 * GraphControl.MEGAUNITS : (20.0 * GraphControl.MEGAUNITS >= dSecondFrameRefY ? 20.0 * GraphControl.MEGAUNITS : 50.0 * GraphControl.MEGAUNITS)))))));
                this.m_iSecondMajorUnitTypeY = 6;
                this.m_dSecondMajorUnitYTypeValue = GraphControl.MEGAUNITS;
                this.m_strSecondYAxisLabelShort = "M" + this.m_strSecondYAxisBaseUnitShort;
                this.m_strSecondYAxisLabel = "mega" + this.m_strSecondYAxisBaseUnit;
            }
            iSecondNumYDivisions = (int)(dSecondDifferenceY / dSecondMajorUnitY) + 2;
            ystart = this.m_dSecondYAxisLowerLimit / dSecondMajorUnitY <= this.Floor(this.m_dSecondYAxisLowerLimit / dSecondMajorUnitY) ? this.Floor(this.m_dSecondYAxisLowerLimit / dSecondMajorUnitY) * dSecondMajorUnitY - dSecondMajorUnitY : this.Floor(this.m_dSecondYAxisLowerLimit / dSecondMajorUnitY) * dSecondMajorUnitY;
            pixelMajorUnitY = (int)(dSecondMajorUnitY / this.m_dSecondYMultiplier) + 1;
            iMajorUnitsPerLabelY = metricsYAxisDivision.stringWidth("8888.8") / pixelMajorUnitY + 1;
            i = 0;
            while (i < iSecondNumYDivisions) {
                ypos = (int)this.m_rectGraph.bottom + (int)((ystart - this.m_dSecondYAxisLowerLimit + dSecondMajorUnitY * (double)i) * this.m_dSecondInvYMultiplier);
                if ((double)ypos >= this.m_rectGraph.bottom && (double)ypos <= this.m_rectGraph.top) {
                    dValue = ystart + dSecondMajorUnitY * (double)i;
                    if (this.m_iSecondMajorUnitTypeY == 6) {
                        dBaseValue = 0.0;
                        dNextBaseValue = 0.0;
                    } else if (this.m_iSecondMajorUnitTypeY == 5) {
                        dBaseValue = this.Floor(dValue / this.m_dSecondNextMajorUnitYTypeValue) * this.m_dSecondNextMajorUnitYTypeValue;
                        dNextBaseValue = 0.0;
                    } else {
                        dBaseValue = this.Floor(dValue / this.m_dSecondNextMajorUnitYTypeValue) * this.m_dSecondNextMajorUnitYTypeValue;
                        dNextBaseValue = this.Floor(dValue / this.m_dSecondNextNextMajorUnitYTypeValue) * this.m_dSecondNextNextMajorUnitYTypeValue;
                    }
                    dDisplayValue = (dValue - dBaseValue) / this.m_dSecondMajorUnitYTypeValue;
                    dNextDisplayValue = (dValue - dNextBaseValue) / this.m_dSecondNextMajorUnitYTypeValue;
                    if (dDisplayValue == 0.0) {
                        gl.glColor3f(0.2f, 0.2f, 0.2f);
                        gl.glBegin(1);
                        gl.glVertex2i((int)(this.m_rectGraph.right + (double)GREAT_LINE_LENGTH), ypos);
                        gl.glVertex2i((int)this.m_rectGraph.right, ypos);
                        gl.glEnd();
                        str = decformat.format(dNextDisplayValue);
                        if (dValue != 0.0) {
                            str = String.valueOf(str) + strSecondNextYAxisLabel;
                        }
                        this.printGL(this.m_rendererYAxisDivision, (int)(this.m_rectGraph.right + (double)GREAT_LINE_LENGTH + 2.0), ypos, GraphControl.JUSTIFY_CENTER, 270.0f, str);
                    } else {
                        x2 = dValue / dSecondMajorUnitY / (double)iMajorUnitsPerLabelY;
                        x3 = this.Floor(x2);
                        if (x2 == x3) {
                            str = decformat.format(dDisplayValue);
                            this.printGL(this.m_rendererYAxisDivision, (int)(this.m_rectGraph.right + (double)MAJOR_LINE_LENGTH + 2.0), ypos, GraphControl.JUSTIFY_CENTER, 270.0f, str);
                        }
                        gl.glColor3f(0.2f, 0.2f, 0.2f);
                        gl.glBegin(1);
                        gl.glVertex2i((int)(this.m_rectGraph.right + (double)MAJOR_LINE_LENGTH), ypos);
                        gl.glVertex2i((int)this.m_rectGraph.right, ypos);
                        gl.glEnd();
                    }
                }
                gl.glColor3f(0.2f, 0.2f, 0.2f);
                j = 1;
                while (j < 5) {
                    extraypos = (int)(dSecondMajorUnitY * ((double)j / 5.0) * this.m_dSecondInvYMultiplier);
                    if ((double)(ypos + extraypos) >= this.m_rectGraph.bottom && (double)(ypos + extraypos) <= this.m_rectGraph.top) {
                        gl.glBegin(1);
                        gl.glVertex2i((int)(this.m_rectGraph.right + (double)MINOR_LINE_LENGTH), ypos + extraypos);
                        gl.glVertex2i((int)this.m_rectGraph.right, ypos + extraypos);
                        gl.glEnd();
                    }
                    ++j;
                }
                ++i;
            }
        }
        gl.glColor3f(0.2f, 0.2f, 0.2f);
        gl.glBegin(3);
        gl.glVertex2i((int)this.m_rectGraph.left, (int)this.m_rectGraph.top);
        gl.glVertex2i((int)this.m_rectGraph.left, (int)this.m_rectGraph.bottom);
        gl.glVertex2i((int)this.m_rectGraph.right, (int)this.m_rectGraph.bottom);
        if (this.m_bSecondYAxisVisible) {
            gl.glVertex2i((int)this.m_rectGraph.right, (int)this.m_rectGraph.top);
        }
        gl.glEnd();
        str = String.format("%s (%s)", new Object[]{this.m_strYAxisTitle, this.m_strYAxisLabel});
        this.printGL(this.m_rendererYAxisLabel, (int)(rectWindow.left + (double)metricsYAxisLabel.getHeight()), (int)(this.m_rectGraph.bottom + Math.abs(this.m_rectGraph.top - this.m_rectGraph.bottom) / 2.0), GraphControl.JUSTIFY_CENTER, 90.0f, str);
        if (this.m_bSecondYAxisVisible) {
            str = String.format("%s (%s)", new Object[]{this.m_strSecondYAxisTitle, this.m_strSecondYAxisLabel});
            this.printGL(this.m_rendererYAxisLabel, (int)(rectWindow.right - (double)metricsYAxisLabel.getHeight()), (int)(this.m_rectGraph.bottom + Math.abs(this.m_rectGraph.top - this.m_rectGraph.bottom) / 2.0), GraphControl.JUSTIFY_CENTER, 270.0f, str);
        }
        str = this.m_bXAxisIsTime != false ? String.format("Time (%s)", new Object[]{this.m_strXAxisLabel}) : String.format("%s (%s)", new Object[]{this.m_strXAxisTitle, this.m_strXAxisLabel});
        iBottomOfXMarker = (int)(this.m_rectGraph.bottom - (double)(metricsXAxisDivision.getHeight() + GREAT_LINE_LENGTH));
        iSpaceOnBottom = (int)((double)iBottomOfXMarker - rectWindow.bottom);
        iTextPos = 0;
        iTextPos = this.m_bXAxisRangeIndicatorsVisible != false ? (int)(this.m_rectGraph.bottom - (double)(metricsXAxisDivision.getHeight() + GREAT_LINE_LENGTH) - (double)(iSpaceOnBottom / 2 + metricsXAxisLabel.getHeight() / 2)) : (int)(this.m_rectGraph.bottom - (double)(metricsXAxisDivision.getHeight() + GREAT_LINE_LENGTH) - 3.0 - (double)(metricsXAxisLabel.getHeight() / 2));
        this.printGL(this.m_rendererXAxisLabel, (int)(this.m_rectGraph.left + (this.m_rectGraph.right - this.m_rectGraph.left) / 2.0), iTextPos, GraphControl.JUSTIFY_CENTER, 0.0f, str);
    }

    public void DrawChannelLines() {
        GL gl = this.getGL();
        DPoint dLastPoint = new DPoint();
        DPoint dCurrentPoint = new DPoint();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        int i = 0;
        i = 0;
        while (i < this.m_vectDataSeries.size()) {
            double dRectViewBottom;
            double dInvYMultiplier;
            gl.glLineWidth((float)this.m_vectDataSeries.get((int)i).iLineThickness);
            float linercolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getRed() / 255.0f;
            float linegcolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getGreen() / 255.0f;
            float linebcolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getBlue() / 255.0f;
            float markerrcolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getRed() / 255.0f;
            float markergcolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getGreen() / 255.0f;
            float markerbcolor = (float)this.m_vectDataSeries.get((int)i).clrLineColor.getBlue() / 255.0f;
            int j = 0;
            if (!this.m_vectDataSeries.get((int)i).bUseSecondScale) {
                dInvYMultiplier = this.m_dInvYMultiplier;
                dRectViewBottom = this.m_drectView.bottom;
            } else {
                dInvYMultiplier = this.m_dSecondInvYMultiplier;
                dRectViewBottom = this.m_dSecondYAxisLowerLimit;
            }
            j = 0;
            while (j < this.m_vectDataSeries.get((int)i).vectDataArray.size()) {
                DPoint bdLastPoint;
                if (j == 0) {
                    bdLastPoint = this.m_vectDataSeries.get((int)i).vectDataArray.get(0);
                    dLastPoint.x = this.m_rectGraph.left + this.m_dInvXMultiplier * (bdLastPoint.x - this.m_drectView.left);
                    dLastPoint.y = this.m_rectGraph.bottom + dInvYMultiplier * (bdLastPoint.y - dRectViewBottom);
                } else {
                    DPoint dRightPoint;
                    DPoint dLeftPoint;
                    DPoint bdCurrentPoint = this.m_vectDataSeries.get((int)i).vectDataArray.get(j);
                    dCurrentPoint.x = this.m_rectGraph.left + this.m_dInvXMultiplier * (bdCurrentPoint.x - this.m_drectView.left);
                    dCurrentPoint.y = this.m_rectGraph.bottom + dInvYMultiplier * (bdCurrentPoint.y - dRectViewBottom);
                    if (dCurrentPoint.x > dLastPoint.x) {
                        dLeftPoint = dLastPoint;
                        dRightPoint = dCurrentPoint;
                    } else {
                        dLeftPoint = dCurrentPoint;
                        dRightPoint = dLastPoint;
                    }
                    if (!(dLeftPoint.x < this.m_rectGraph.left && dRightPoint.x < this.m_rectGraph.left || dLeftPoint.x > this.m_rectGraph.right && dRightPoint.x > this.m_rectGraph.right || dLeftPoint.y < this.m_rectGraph.bottom && dRightPoint.y < this.m_rectGraph.bottom || dLeftPoint.y > this.m_rectGraph.top && dRightPoint.y > this.m_rectGraph.top)) {
                        double dLeftVal;
                        double dRightVal;
                        double dSlope;
                        if (dLeftPoint.x >= this.m_rectGraph.left && dRightPoint.x >= this.m_rectGraph.left && dLeftPoint.x <= this.m_rectGraph.right && dRightPoint.x <= this.m_rectGraph.right && dLeftPoint.y >= this.m_rectGraph.bottom && dRightPoint.y >= this.m_rectGraph.bottom && dLeftPoint.y <= this.m_rectGraph.top && dRightPoint.y <= this.m_rectGraph.top) {
                            x1 = (int)dLeftPoint.x;
                            y1 = (int)dLeftPoint.y;
                            x2 = (int)dRightPoint.x;
                            y2 = (int)dRightPoint.y;
                        } else if (dLeftPoint.x >= this.m_rectGraph.left && dLeftPoint.x <= this.m_rectGraph.right && dLeftPoint.y >= this.m_rectGraph.bottom && dLeftPoint.y <= this.m_rectGraph.top && (dRightPoint.y < this.m_rectGraph.bottom || dRightPoint.y > this.m_rectGraph.top || dRightPoint.x < this.m_rectGraph.left || dRightPoint.x > this.m_rectGraph.right)) {
                            dSlope = (dRightPoint.y - dLeftPoint.y) / (dRightPoint.x - dLeftPoint.x);
                            dRightVal = dSlope * (this.m_rectGraph.right - dLeftPoint.x) + dLeftPoint.y;
                            if (this.m_rectGraph.top < dRightVal) {
                                x2 = (int)((this.m_rectGraph.top - dLeftPoint.y) / dSlope + dLeftPoint.x);
                                y2 = (int)this.m_rectGraph.top;
                            } else if (this.m_rectGraph.bottom > dRightVal) {
                                x2 = (int)((this.m_rectGraph.bottom - dLeftPoint.y) / dSlope + dLeftPoint.x);
                                y2 = (int)this.m_rectGraph.bottom;
                            } else {
                                x2 = (int)this.m_rectGraph.right;
                                y2 = (int)dRightVal;
                            }
                            x1 = (int)dLeftPoint.x;
                            y1 = (int)dLeftPoint.y;
                        } else if (dRightPoint.x >= this.m_rectGraph.left && dRightPoint.x <= this.m_rectGraph.right && dRightPoint.y >= this.m_rectGraph.bottom && dRightPoint.y <= this.m_rectGraph.top && (dLeftPoint.y < this.m_rectGraph.bottom || dLeftPoint.y > this.m_rectGraph.top || dLeftPoint.x < this.m_rectGraph.left || dLeftPoint.x > this.m_rectGraph.right)) {
                            dSlope = (dRightPoint.y - dLeftPoint.y) / (dRightPoint.x - dLeftPoint.x);
                            dLeftVal = dSlope * (this.m_rectGraph.left - dRightPoint.x) + dRightPoint.y;
                            if (this.m_rectGraph.top < dLeftVal) {
                                x1 = (int)((this.m_rectGraph.top - dRightPoint.y) / dSlope + dRightPoint.x);
                                y1 = (int)this.m_rectGraph.top;
                            } else if (this.m_rectGraph.bottom > dLeftVal) {
                                x1 = (int)((this.m_rectGraph.bottom - dRightPoint.y) / dSlope + dRightPoint.x);
                                y1 = (int)this.m_rectGraph.bottom;
                            } else {
                                x1 = (int)this.m_rectGraph.left;
                                y1 = (int)dLeftVal;
                            }
                            x2 = (int)dRightPoint.x;
                            y2 = (int)dRightPoint.y;
                        } else if ((dRightPoint.x < this.m_rectGraph.left || dRightPoint.x > this.m_rectGraph.right || dRightPoint.y < this.m_rectGraph.bottom || dRightPoint.y > this.m_rectGraph.top) && (dLeftPoint.x < this.m_rectGraph.left || dLeftPoint.x > this.m_rectGraph.right || dLeftPoint.y < this.m_rectGraph.bottom || dLeftPoint.y > this.m_rectGraph.top)) {
                            dSlope = (dRightPoint.y - dLeftPoint.y) / (dRightPoint.x - dLeftPoint.x);
                            dRightVal = dSlope * (this.m_rectGraph.right - dRightPoint.x) + dRightPoint.y;
                            dLeftVal = dSlope * (this.m_rectGraph.left - dRightPoint.x) + dRightPoint.y;
                            if (this.m_rectGraph.top < dRightVal) {
                                x2 = (int)((this.m_rectGraph.top - dRightPoint.y) / dSlope + dRightPoint.x);
                                y2 = (int)this.m_rectGraph.top;
                            } else if (this.m_rectGraph.bottom > dRightVal) {
                                x2 = (int)((this.m_rectGraph.bottom - dRightPoint.y) / dSlope + dRightPoint.x);
                                y2 = (int)this.m_rectGraph.bottom;
                            } else {
                                x2 = (int)this.m_rectGraph.right;
                                y2 = (int)dRightVal;
                            }
                            if (this.m_rectGraph.top < dLeftVal) {
                                x1 = (int)((this.m_rectGraph.top - dRightPoint.y) / dSlope + dRightPoint.x);
                                y1 = (int)this.m_rectGraph.top;
                            } else if (this.m_rectGraph.bottom > dLeftVal) {
                                x1 = (int)((this.m_rectGraph.bottom - dRightPoint.y) / dSlope + dRightPoint.x);
                                y1 = (int)this.m_rectGraph.bottom;
                            } else {
                                x1 = (int)this.m_rectGraph.left;
                                y1 = (int)dLeftVal;
                            }
                        }
                        if (!this.m_vectDataSeries.get((int)i).bOnlyMarkers) {
                            gl.glColor3f(linercolor, linegcolor, linebcolor);
                            gl.glBegin(1);
                            gl.glVertex2i(x1, y1);
                            gl.glVertex2i(x2, y2);
                            gl.glEnd();
                        } else {
                            gl.glColor3f(markerrcolor, markergcolor, markerbcolor);
                            gl.glBegin(6);
                            gl.glVertex2i(x1, y1);
                            double dAngle = 0.0;
                            while (dAngle <= 360.0) {
                                gl.glVertex2d((double)x1 + Math.sin(dAngle) * 2.0, (double)y1 + Math.cos(dAngle) * 2.0);
                                dAngle += 5.0;
                            }
                            gl.glEnd();
                            if (j == this.m_vectDataSeries.get((int)i).vectDataArray.size() - 1) {
                                gl.glBegin(6);
                                gl.glVertex2i(x2, y2);
                                dAngle = 0.0;
                                while (dAngle <= 360.0) {
                                    gl.glVertex2d((double)x2 + Math.sin(dAngle) * 2.0, (double)y2 + Math.cos(dAngle) * 2.0);
                                    dAngle += 5.0;
                                }
                                gl.glEnd();
                            }
                        }
                    }
                    bdLastPoint = bdCurrentPoint;
                    dLastPoint.x = dCurrentPoint.x;
                    dLastPoint.y = dCurrentPoint.y;
                }
                ++j;
            }
            ++i;
        }
        gl.glLineWidth(1.0f);
    }

    private void drawZoomBox() {
        GL gl = this.getGL();
        if (this.m_iMode != 1 && this.m_iMode != 2) {
            return;
        }
        if (this.m_bZoomToolTracking) {
            gl.glColor3f(0.3f, 0.3f, 0.3f);
            gl.glBegin(2);
            gl.glVertex2d(this.m_ZoomSelRect.left, this.m_ZoomSelRect.top);
            gl.glVertex2d(this.m_ZoomSelRect.right, this.m_ZoomSelRect.top);
            gl.glVertex2d(this.m_ZoomSelRect.right, this.m_ZoomSelRect.bottom);
            gl.glVertex2d(this.m_ZoomSelRect.left, this.m_ZoomSelRect.bottom);
            gl.glEnd();
        }
    }

    private void drawLineLabels() {
        GL gl = this.getGL();
        gl.glEnable(2852);
        gl.glLineStipple(1, (short)-3856);
        gl.glColor3f(0.3f, 0.3f, 0.3f);
        int i = 0;
        while (i < this.m_vectLineMarkers.size()) {
            gl.glBegin(1);
            gl.glVertex2d(this.m_rectGraph.left + this.m_dInvXMultiplier * (this.m_vectLineMarkers.get((int)i).dTime * MINUTES - this.m_drectView.left), this.m_rectGraph.top);
            gl.glVertex2d(this.m_rectGraph.left + this.m_dInvXMultiplier * (this.m_vectLineMarkers.get((int)i).dTime * MINUTES - this.m_drectView.left), this.m_rectGraph.bottom);
            gl.glEnd();
            this.printGLColor(this.m_rendererYAxisDivision, (int)(this.m_rectGraph.left + this.m_dInvXMultiplier * (this.m_vectLineMarkers.get((int)i).dTime * MINUTES - this.m_drectView.left)) - 1, (int)(this.m_rectGraph.bottom + 3.0), JUSTIFY_LEFT, 90.0f, this.m_vectLineMarkers.get((int)i).strMarkerName, 0.3f, 0.3f, 0.3f, 1.0f);
            ++i;
        }
        gl.glDisable(2852);
    }

    private void printGL(TextRenderer renderer, int x, int y, int iJustification, float fAngle, String str) {
        this.printGLColor(renderer, x, y, iJustification, fAngle, str, 0.2f, 0.2f, 0.2f, 1.0f);
    }

    private void printGLColor(TextRenderer renderer, int x, int y, int iJustification, float fAngle, String str, float R, float G, float B, float A) {
        GL gl = this.getGL();
        Graphics graphics = this.getGraphics();
        FontMetrics metrics = graphics.getFontMetrics(renderer.getFont());
        renderer.beginRendering(this.getWidth(), this.getHeight());
        gl.glMatrixMode(5888);
        renderer.setColor(R, G, B, A);
        gl.glLoadIdentity();
        gl.glTranslatef((float)x, (float)y, 0.0f);
        gl.glRotatef(fAngle, 0.0f, 0.0f, 1.0f);
        if (iJustification == JUSTIFY_CENTER) {
            gl.glTranslatef((float)(0 - metrics.stringWidth(str) / 2), 0.0f, 0.0f);
        } else if (iJustification == JUSTIFY_RIGHT) {
            gl.glTranslatef((float)(0 - metrics.stringWidth(str)), 0.0f, 0.0f);
        }
        renderer.draw(str, 0, 0);
        renderer.endRendering();
    }

    private double Floor(double dNumber) {
        if (dNumber > 0.0) {
            return Math.floor(dNumber);
        }
        if (dNumber < 0.0) {
            return Math.ceil(dNumber);
        }
        return 0.0;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (!this.m_bControlsEnabled) {
            return;
        }
        if (this.m_iMode == 0) {
            this.setCursor(this.m_curClosedHand);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (!this.m_bControlsEnabled) {
            return;
        }
        if (this.m_iMode == 0) {
            this.setCursor(this.m_curOpenHand);
        }
    }

    public void setYAxisTitle(String strTitle) {
        this.m_strYAxisTitle = strTitle;
    }

    public void setXAxisTitle(String strTitle) {
        this.m_strXAxisTitle = strTitle;
    }

    public void setXAxisType(boolean bIsTime) {
        this.m_bXAxisIsTime = bIsTime;
    }

    public void setSecondYAxisTitle(String strTitle) {
        this.m_strSecondYAxisTitle = strTitle;
    }

    public void setYAxisBaseUnit(String strBaseUnit, String strBaseUnitAbbreviated) {
        this.m_strYAxisBaseUnit = strBaseUnit;
        this.m_strYAxisBaseUnitShort = strBaseUnitAbbreviated;
    }

    public void setXAxisBaseUnit(String strBaseUnit, String strBaseUnitAbbreviated) {
        this.m_strXAxisBaseUnit = strBaseUnit;
        this.m_strXAxisBaseUnitShort = strBaseUnitAbbreviated;
    }

    public void setSecondYAxisBaseUnit(String strBaseUnit, String strBaseUnitAbbreviated) {
        this.m_strSecondYAxisBaseUnit = strBaseUnit;
        this.m_strSecondYAxisBaseUnitShort = strBaseUnitAbbreviated;
    }

    public boolean setYAxisRangeLimits(double dMinimum, double dMaximum) {
        if (dMaximum * UNITS > 9.0 * MEGAUNITS) {
            return false;
        }
        if (dMinimum * UNITS < -9.0 * MEGAUNITS) {
            return false;
        }
        if (dMaximum <= dMinimum) {
            return false;
        }
        this.m_dYAxisUpperLimit = dMaximum * UNITS;
        this.m_dYAxisLowerLimit = dMinimum * UNITS;
        return true;
    }

    public boolean setXAxisRangeLimits(double dMinimum, double dMaximum) {
        if (dMaximum * UNITS > 9.0 * MEGAUNITS) {
            return false;
        }
        if (dMinimum * UNITS < -9.0 * MEGAUNITS) {
            return false;
        }
        if (dMaximum <= dMinimum) {
            return false;
        }
        this.m_dXAxisUpperLimit = dMaximum * UNITS;
        this.m_dXAxisLowerLimit = dMinimum * UNITS;
        return true;
    }

    public boolean setSecondYAxisRangeLimits(double dMinimum, double dMaximum) {
        if (dMaximum * UNITS > 9.0 * MEGAUNITS) {
            return false;
        }
        if (dMinimum * UNITS < -9.0 * MEGAUNITS) {
            return false;
        }
        if (dMaximum <= dMinimum) {
            return false;
        }
        this.m_dSecondYAxisUpperLimit = dMaximum * UNITS;
        this.m_dSecondYAxisLowerLimit = dMinimum * UNITS;
        return true;
    }

    public void setYAxisRangeIndicatorsVisible(Boolean bVisible) {
        this.m_bYAxisRangeIndicatorsVisible = bVisible;
    }

    public void setXAxisRangeIndicatorsVisible(Boolean bVisible) {
        this.m_bXAxisRangeIndicatorsVisible = bVisible;
    }

    public void setSecondYAxisVisible(Boolean bVisible) {
        this.m_bSecondYAxisVisible = bVisible;
    }

    public int AddSeries(String strSeriesName, Color clrLineColor, int iLineThickness, boolean bOnlyMarkers, boolean bUseSecondScale) {
        DataSeries dataSeries = new DataSeries();
        dataSeries.strName = strSeriesName;
        dataSeries.clrLineColor = clrLineColor;
        dataSeries.iLineThickness = iLineThickness;
        dataSeries.bOnlyMarkers = bOnlyMarkers;
        dataSeries.bUseSecondScale = bUseSecondScale;
        int i = 0;
        while (i <= this.m_vectDataSeries.size()) {
            boolean bFound = false;
            int j = 0;
            while (j < this.m_vectDataSeries.size()) {
                if (this.m_vectDataSeries.get((int)j).iIndex == i) {
                    bFound = true;
                    break;
                }
                ++j;
            }
            if (!bFound) {
                dataSeries.iIndex = i;
            }
            ++i;
        }
        this.m_vectDataSeries.add(dataSeries);
        return dataSeries.iIndex;
    }

    public boolean RemoveSeries(int iSeriesIndex) {
        int iIndex = this.getSeriesFromIndex(iSeriesIndex);
        if (iIndex == -1) {
            return false;
        }
        this.m_vectDataSeries.remove(iIndex);
        return true;
    }

    private int getSeriesFromIndex(int iIndex) {
        int i = 0;
        while (i < this.m_vectDataSeries.size()) {
            if (this.m_vectDataSeries.get((int)i).iIndex == iIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void RemoveAllSeries() {
        this.m_vectDataSeries.removeAllElements();
    }

    public boolean AddDataPoint(int iSeriesIndex, double dXVal, double dYVal) {
        int iIndex = this.getSeriesFromIndex(iSeriesIndex);
        if (iIndex == -1) {
            return false;
        }
        DataSeries dataSeries = this.m_vectDataSeries.get(iIndex);
        if (dataSeries == null) {
            return false;
        }
        DPoint dPoint = new DPoint();
        dPoint.x = dXVal * SECONDS;
        dPoint.y = dYVal * UNITS;
        if (dataSeries.vectDataArray.size() == 0) {
            dataSeries.dXMax = dPoint.x;
            dataSeries.dXMin = dPoint.x;
            dataSeries.dYMax = dPoint.y;
            dataSeries.dYMin = dPoint.y;
        } else {
            if (dPoint.x > dataSeries.dXMax) {
                dataSeries.dXMax = dPoint.x;
            }
            if (dPoint.x < dataSeries.dXMin) {
                dataSeries.dXMin = dPoint.x;
            }
            if (dPoint.y > dataSeries.dYMax) {
                dataSeries.dYMax = dPoint.y;
            }
            if (dPoint.y < dataSeries.dYMin) {
                dataSeries.dYMin = dPoint.y;
            }
        }
        dataSeries.vectDataArray.add(dPoint);
        return true;
    }

    public void addLineMarker(double dTimeInMinutes, String strLabel) {
        LineMarker lineMarker = new LineMarker();
        lineMarker.dTime = dTimeInMinutes;
        lineMarker.strMarkerName = strLabel;
        this.m_vectLineMarkers.add(lineMarker);
    }

    public void removeAllLineMarkers() {
        this.m_vectLineMarkers.removeAllElements();
    }

    public boolean AutoScaleToSeries(int iSeriesIndex) {
        int iIndex = this.getSeriesFromIndex(iSeriesIndex);
        if (iIndex == -1) {
            return false;
        }
        DataSeries dataSeries = this.m_vectDataSeries.get(iIndex);
        if (dataSeries == null) {
            return false;
        }
        if (dataSeries.vectDataArray.size() < 2) {
            return false;
        }
        this.m_drectView.bottom = 0.0;
        this.m_drectView.top = dataSeries.dYMax;
        this.m_drectView.right = dataSeries.dXMax;
        this.m_drectView.left = dataSeries.dXMin;
        return true;
    }

    public boolean AutoScaleX() {
        double dXMin = 0.0;
        double dXMax = 0.0;
        boolean bUninitialized = true;
        if (this.m_vectDataSeries.size() == 0) {
            return false;
        }
        DataSeries dataSeries = null;
        int i = 0;
        while (i < this.m_vectDataSeries.size()) {
            dataSeries = this.m_vectDataSeries.get(i);
            if (dataSeries.vectDataArray.size() > 1 && !dataSeries.bUseSecondScale) {
                if (dataSeries.dXMin < dXMin || bUninitialized) {
                    dXMin = dataSeries.dXMin;
                }
                if (dataSeries.dXMax > dXMax || bUninitialized) {
                    dXMax = dataSeries.dXMax;
                }
                bUninitialized = false;
            }
            ++i;
        }
        this.m_drectView.right = dXMax;
        this.m_drectView.left = dXMin;
        return true;
    }

    public boolean AutoScaleY() {
        double dYMin = 0.0;
        double dYMax = 0.0;
        boolean bUninitialized = true;
        if (this.m_vectDataSeries.size() == 0) {
            return false;
        }
        DataSeries dataSeries = null;
        int i = 0;
        while (i < this.m_vectDataSeries.size()) {
            dataSeries = this.m_vectDataSeries.get(i);
            if (dataSeries.vectDataArray.size() > 1 && !dataSeries.bUseSecondScale) {
                if (dataSeries.dYMin < dYMin || bUninitialized) {
                    dYMin = dataSeries.dYMin;
                }
                if (dataSeries.dYMax > dYMax || bUninitialized) {
                    dYMax = dataSeries.dYMax;
                }
                bUninitialized = false;
            }
            ++i;
        }
        double dAverage = (dYMin + dYMax) / 2.0;
        if (dYMax - dYMin < dAverage * 0.001) {
            dYMax = dAverage + dAverage * 0.01;
            dYMin = dAverage - dAverage * 0.01;
        }
        if (dYMax - dYMin < 0.001) {
            dYMax = dAverage + 1.0 * UNITS;
            dYMin = dAverage - 1.0 * UNITS;
        }
        this.m_drectView.bottom = dYMin;
        this.m_drectView.top = dYMax;
        return true;
    }

    void selectPanMode() {
        this.m_iMode = 0;
        this.setCursor(this.m_curOpenHand);
    }

    void selectZoomInMode() {
        this.m_iMode = 1;
        this.setCursor(this.m_curZoomIn);
    }

    void selectZoomOutMode() {
        this.m_iMode = 2;
        this.setCursor(this.m_curZoomOut);
    }

    public void setVisibleWindow(double dStartTime, double dEndTime, double dBottom, double dTop) {
        this.m_drectView.left = dStartTime * SECONDS;
        this.m_drectView.top = dTop * UNITS;
        this.m_drectView.right = dEndTime * SECONDS;
        this.m_drectView.bottom = dBottom * UNITS;
    }

    void setAutoScaleX(boolean bAutoScaleX) {
        this.m_bAutoScaleX = bAutoScaleX;
        if (bAutoScaleX) {
            this.AutoScaleX();
        }
        this.fireAutoScaleChangedEvent();
    }

    void setAutoScaleY(boolean bAutoScaleY) {
        this.m_bAutoScaleY = bAutoScaleY;
        if (bAutoScaleY) {
            this.AutoScaleY();
        }
        this.fireAutoScaleChangedEvent();
    }

    boolean getAutoScaleX() {
        return this.m_bAutoScaleX;
    }

    boolean getAutoScaleY() {
        return this.m_bAutoScaleY;
    }

    public synchronized void addAutoScaleListener(AutoScaleListener l) {
        this._listeners.add(l);
    }

    public synchronized void removeMoodListener(AutoScaleListener l) {
        this._listeners.remove(l);
    }

    private synchronized void fireAutoScaleChangedEvent() {
        AutoScaleEvent autoScaleEvent = new AutoScaleEvent(this, this.m_bAutoScaleX, this.m_bAutoScaleY);
        Iterator<AutoScaleListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().autoScaleChanged(autoScaleEvent);
        }
    }

    public void setControlsEnabled(boolean bEnabled) {
        this.m_bControlsEnabled = bEnabled;
        if (!bEnabled) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public class DPoint {
        double x;
        double y;
    }

    public class DRect {
        double left;
        double right;
        double bottom;
        double top;

        public DRect() {
            this.left = 0.0;
            this.right = 0.0;
            this.bottom = 0.0;
            this.top = 0.0;
        }

        public DRect(DRect r) {
            this.left = r.left;
            this.right = r.right;
            this.top = r.top;
            this.bottom = r.bottom;
        }

        public double getHeight() {
            return Math.abs(this.top - this.bottom);
        }

        public double getWidth() {
            return Math.abs(this.right - this.left);
        }
    }

    public class DataSeries {
        int iIndex;
        String strName = "";
        Color clrLineColor = new Color(0, 0, 0);
        int iLineThickness = 1;
        Vector<DPoint> vectDataArray = new Vector();
        boolean bOnlyMarkers = false;
        boolean bUseSecondScale = false;
        double dXMin;
        double dYMin;
        double dXMax;
        double dYMax;
    }

    public class LineMarker {
        String strMarkerName = "";
        double dTime = 0.0;
    }
}

